---
title: "La BOM, spécificité technique d'une solution PLM"
date: 2022-09-19
categories: 
  - "plm"
coverImage: "vadim-sherbakov-osSryggkso4-unsplash-scaled-e1663573380175.jpg"
---

13 ans passés dans le domaine technique du PLM et il n'y a pas une année sans que je ne remette en question les solutions PLM du marché. Les mondes du développement logiciel et du développement web évoluent constamment et chaque avancé me lance dans une analyse sur la capacité à fournir des solutions plus simples à manipuler avec de meilleurs performances, des interfaces plus simples, etc. Il y a toujours une marge d'amélioration à aller chercher.

## Les innovations qui interpellent

Les innovations qui m'interpellent en lien avec le monde du PLM sont toutes les innovations qui vont me permettre de:

- gérer de la donnée plus simplement et de manière plus efficace
- servir plus de requêtes sans rajouter plus de hardware
- avoir des traitements applicatifs plus rapides et moins gourmands en énergie.
- Favoriser le développement d'interfaces flexibles tout en permettant des interfaces dédiées aux métiers.

Cela se traduit par les domaines logiciels suivants:

- Nouvelles bases de données (memgraph, surrealDb,...)
- Nouvelles technologies de serveur web
- Différents types de langages de développement (ex: Rust)
- Différents framework de développement client (ex: React, VueJs, Angular,...)

## Le web tiré par le e-commerce

Depuis longtemps et surtout depuis la sortie d'html5, je me suis rendu compte que le développement web était tiré par un web qui ne correspond pas au PLM. Il est tiré par le besoin de publier du contenu pour tirer des flux d'utilisateurs vers du e-commerce. Par exemple, un des critères principaux est le temps de chargement de la première page d'un site. Ce critère a tiré un grand nombre de développements autour du server-side rendering par exemple ou sur la compression de librairies, le chargement différé, etc. Vous allez vous connecter tous les jours au PLM donc le temps de chargement de votre première visite a peu d'importance, si la mise en cache permet de rendre les chargement rapides par la suite.

## On en revient toujours à la BOM

Il y a un domaine pour lequel on ne voit pas de publications technologiques fortes, c'est la gestion de la nomenclature d'un point de vu logiciel. En traduction technique, la gestion de données connectées récursives. Impossible avec des bases de données de type document-db. Couteux avec du SQL, la nomenclature se gère très bien avec une base graphe mais pose tout de même des questions de gestion pour l'utilisateur.

- Est-ce que l'utilisateur a besoin de récupérer toute la nomenclature (ou niveau par niveau)
- Est-ce que la gestion des permissions s'applique différemment selon l'élément de la nomenclature.
- Comment évolue cette nomenclature dans le temps (gestion de configuration)
- Quel est l'historique à conserver d'une nomenclature (la réponse habituelle est : on veut tout garder et retrouver)

La plupart de mes clients sont des industries établies avec une certaines experience du PLM. Pour répondre aux problématiques que je viens d'évoquer, j'aime bien me mettre à la place de la startup qui démarre une projet hardware/software. Elle ne sait pas ce qu'elle risque à utiliser excel pour gérer sa nomenclature et je veux gagner la selection face à Excel.

Des réflexions à suivre...
