---
title: "Améliorer un produit en connaissant ses données connexes"
date: 2022-04-14
categories: 
  - "deep-learning"
  - "plm"
coverImage: "IMG_20180920_095717.jpg"
---

Je fouillais dans des photos de la conférence Graph Connect 2018, et je suis retombé sur cette citation:

[![](images/IMG_20180920_095717-1-1024x576.jpg)](https://plm-ouvert.fr/wp-content/uploads/2022/04/IMG_20180920_095717-1.jpg)

Ce qui en français donne :

> "Nous apprenons de plus en plus que vous pouvez faire de meilleures prédictions sur les gens en obtenant toutes les informations de leurs amis et des amis de leurs amis que vous ne le pouvez à partir des informations que vous avez sur la personne elle-même"
> 
> Dr James Fowler

Et mon habitude à tout ramener au PLM m'amène donc à poser la question concernant les informations de définition d'un produit.

## Les apports d'un contexte élargi

Quelles sont les informations complémentaires à la définition du produit qui me permettent d'en savoir plus sur celui-ci? Les retours utilisateurs, les spécifications, les moyens de production, etc. Toutes ces informations permettent clairement d'en apprendre beaucoup sur le produit et au final d'avoir peut-être des informations plus cruciales que la définition, la maquette numérique du produit lui-même. Il serait d'ailleurs intéressant si à partir de ces informations, une intelligence artificielle pourrait produire cette maquette numérique.

Le contexte est la clé de l'évolution du produit. J'en avais un peu parlé dans mon article: [AI+simulation = design automatisé](https://plm-ouvert.fr/2021/09/ai-simulation-design-automatise/). Le contexte est souvent à la base de design automatisé par contrainte, puisque les contraintes à définir représentent justement le contexte. Actuellement les contraintes sont généralement des contraintes physiques: point d'ancrage, poids, moments,... Mais demain nous pourrons injecter des évaluations d'utilisateurs, des évolutions de normes,... Est-ce qu'il sera nécessaire de conserver une définition de la v1 d'un produit pour réaliser une v2 si la source de la v1 est un contexte défini.

## Les limites d'un PDM pour l'avenir

J'utilise délibérément le terme PDM pour désigner une gestion de la définition du produit ne dépassant la définition directe de ce dernier. Un PDM centré sur le produit risque à termes d'être un handicap. Cela n'empeche pas l'amélioration continue mais la fracture numérique entre la définition du produit et son contexte élargie freine tout usage d'un processus d'amélioration itératif basé sur des intelligence artificielles. Et encore il n'est même pas nécessaire de parler d'intélligence artificielle. L'homme intelligent valorisera d'autant plus son travail s'il a une vision la plus exhaustive possible de l'environnement dans lequel évolue son produit.

## Elargissez le périmètre de votre projet PLM

Encore une fois, il n'est pas obligatoire d'avoir tout son PLM dans un même logiciel. Le but est d'avoir les outils qui vous permettent d'avoir une gestion cohérente des nœuds d'informations et des relations qui constituent votre produit et son contexte. Toute connaissance capitalisable permettant d'enrichir le produit ou son contexte nécessite d'être maitrisé pour préparer l'amélioration et l'adaptation de votre produit aux évolutions des marchés.
