---
title: "Z2 Data - L'information clé sur la supply chain"
date: 2021-10-25
categories: 
  - "api"
  - "mro-soutien-logistique"
  - "plm"
coverImage: "z2data.png"
---

Une de mes activités principales en 2008 lorsque je travaillais dans l'industrie de défense et sécurité était de réaliser une application Access de gestion des informations d'obsolescence. Nous avions une liste de composants qui était envoyée à une entreprise qui nous communiquait principalement des alertes sous forme de PCN (Product Change Notification). Les informations étaient assez limitées mais essentielles à la prise de décision sur l'évolution ou non des produits.

Une alerte de fin de vie d'un composant peut déclencher plusieurs réactions:

- Pas de réaction: l'analyse d'impact ne révèle aucun produit critique, ou un stock de sécurité a déjà été réalisé et le support des équipements actuels est assuré.
- Création d'un stock de sécurité: Les produits impactés doivent être maintenus et il n'est pas prévu de mettre à jour la conception du produit ou les délais de re-conception sont trop longs pour se permettre un risque sur le maintien en condition opérationnelle.
- Lancement d'un nouveau design: Cela peut aller de pair avec la création d'un stock de sécurité. L'analyse du remplacement du composant en question demande une modification plus ou moins importante de votre produit. L'analyse du PCN va provoquer la création d'un ECR.

## Z2 Data

J'ai découvert [Z2 data](https://www.z2data.com/) il y a un peu moins de 2 ans. Un de mes clients de l'autre bout du monde me demande une intégration de sa solution PLM avec une solution reconnue de veille de composants. Le prix de cette solution est assez important et l'API n'est pas hyper lisible, je cherche alors une solution alternative et tombe sur [z2 data](https://www.z2data.com/). Je mets les deux sociétés en relation et mon client devient client de z2 Data dans les semaines qui suivent.

[![](images/z2data-1024x454.png)](https://plm-ouvert.fr/wp-content/uploads/2021/10/z2data.png)

## Des solutions claires

Z2Data présente différentes solutions:

- Part Risk Manager : Analyse les fiches techniques des composants et traite les PCN.
- Supply Chain Watch: Apporte une information sur la supply chain des composants. En ces temps de manque de composants électronique, une telle fonctionnalité permet d'apporter un temps d'avance dans l'analyse des flux logistiques impactant la mise à disposition des composants utilisés.
- Supplier Insight: apporte une évaluation des fournisseurs.
- Alert Tracker: permet une intégration pro-active avec les systèmes d'information pour notifier en direct des évolutions sur la pérennité d'un composant ou sur la santé de sa supply chain.

## Une API bien documentée

Cela devient primordial lorsque vous devez vous intégrez dans un écosystème existant, la documentation d'une API est un must. Z2 Data publie un swagger.

[![](images/swaggerz2data.png)](https://plm-ouvert.fr/wp-content/uploads/2021/10/swaggerz2data.png)

## Intégré à Ganister

Dans le cadre de Ganister, nous n'avons eu aucun mal à implémenter des écrans de recherche de référence et d'affichage des indicateurs de risque sur les composants

<figure>

[![](images/ganisterZ2Data-1024x410.png)](https://plm-ouvert.fr/wp-content/uploads/2021/10/ganisterZ2Data.png)

<figcaption>

Indicateurs de risque

</figcaption>

</figure>

<figure>

[![](images/ganisterZ2Data2-1024x504.png)](https://plm-ouvert.fr/wp-content/uploads/2021/10/ganisterZ2Data2.png)

<figcaption>

Accès aux PCN

</figcaption>

</figure>

Une bonne découverte et une solution à explorer pour ceux qui travaillent sur la gestion d'obsolescence et le maintien en condition opérationnelle des produits.
