---
title: "Une gestion de configuration flexible ?"
date: 2020-05-08
categories: 
  - "cmii-change-management"
  - "plm"
  - "standards"
coverImage: "black-transistor-beside-capacitor-163100-scaled.jpg"
---

Dans le cadre de ma nouvelle aventure [Ganister](https://ganister.eu/), dont je parlerai dans un prochain article, je suis obligé de revoir les basics en lien avec les réflexions sur les ECOs, FFF et versioning. Je vous propose ici la réflexion sur un système de gestion de configuration flexible pensé pour tous.

_\[Edit du 09/05/2020\] Un peu de rappel de lexique comme demandé dans un commentaire Linkedin:_

- _ECO - Engineering/Enterprise Change Order : C'est un objet validé par un workflow qui permet de rassembler un ensemble cohérent de modifications de données de définition. Il contient en général une aide à l'analyse d'impact._
- _FFF- Fit Form Function (certains rajoutent Safety) : Lors de toute révision d'un article, la décision d'incrément d'une révision ou d'une prise de nouvelle référence est souvent liée à cette analyse. Le moindre doute sur le maintient d'un de ces trois critères doit pousser à créer une nouvelle référence._

### Semantic Versioning étendu

Par le passé, j'ai présenté le concept de Semantic Versioning. Très utilisé dans le domaine du logiciel, il repose sur trois digits pour différencier des versions de logiciels. Chaque digit a un sens particulier d'où l'usage du terme "Semantic".

#### Proposition

_Tout type d'objet pourra être configuré pour permettre l'utilisation de 0 à 3 digits afin de différencier différents types de montées de versions._

### Interchangeable / Non-Interchangeable

Je ne vais pas changer le monde, je ne dois pas être le meilleur des combattants pour me battre sur ce sujet. Un système flexible doit donc permettre les deux. Partons du fait que l'on va pouvoir définir sur un type d'objet si la révision de cet objet implique interchangeabilité ou non. Et allons plus loin en donnant la possibilité à chaque entreprise de définir sur la base d'un versioning semantic, si la montée d'un indice ou d'un autre implique interchangeabilité ou non.

#### Proposition

_Tout type d'objet pourra être configuré pour permettre l'utilisation de 0 à 3 digits afin de différencier différents types de montées de versions._

### Fork & Superseding Fork

En lisant les ouvrages sur les bonnes pratiques de gestion de configuration, on tombe rapidement sur le "In doubt, don't revise". Cela indique qu'on doit parfois faire des choix entre incrémenter l'indice d'une révision, ou créer une nouvelle référence dans un système de gestion de configuration. Une nouvelle référence peut être créée parce qu'une évolution casse une interchangeabilité ou simplement change assez une pièce pour qu'on ait besoin de l'identifier autrement. Cette nouvelle référence peut-être au départ une copie et vivre sa vie sans arrêter celle de la pièce d'origine, ou au contraire cette nouvelle référence vient rendre obsolète l'ancienne. Une certaine gestion de configuration s'applique alors sur les assemblages qui contiennent cette pièce (ou autre objet métier).

#### Proposition

_Lors de l'étude d'une évolution, il doit être possible de décider si cette évolution est une version (l'interchangeabilité serait alors préconfigurée comme expliqué plus haut), ou une nouvelle référence. Si nouvelle référence, il doit être aussi possible de préciser si cette nouvelle référence vient remplacer et rendre obsolète l'ancienne ou si ce remplacement peut se limiter à un contexte précis et laisser la pièce d'origine vivre sa vie._

### Des validations unitaires

C'est sûrement la proposition qui sera la plus combattue (je l'ai testé dans des dizaines de discussions). Je vois souvent des ECO qui Release de 10 à 20 nouvelles versions ou nouvelles pièces. Valider en un clic 10 pièces veut dire qu'il y a un process non digitalisé, ou sur un autre système (excel et les emails, au hasard...), de validation de chaque pièce. Certains systèmes permettent de générer des workflows spécifiques pour chaque plan, mais le plan ne représente pas l'intégralité des informations d'une pièce. L'ECO est cependant très utile pour gérer, d'un point de vue projet, un ensemble cohérent d'évolutions.

#### Proposition

_L'ECO est un outil de gestion qui permet de rassembler un lot cohérent de validations et/ou évolutions d'objets métier gérés en configuration. Il peut permettre une analyse d'impact des évolutions prévues et générer les nouvelles versions sur lesquelles travailler. Il ne procède pas à la release des objets contrôlés. Ces derniers sont passé dans un statut Release de manière unitaire. L'ECO permet le suivi de la validation de cet ensemble cohérent._

### Objets de configuration génériques

Se concentrant initialement sur les éléments principaux d'outils de gestion de configuration dans une industrie précise, on adapte les outils de manière extensive pour apporter d'autres objets métiers dans des process initialement réservés à des articles et des documents. Il est nécessaire de rendre cette gestion générique et de permettre à n'importe quel objet métier de rentrer dans ces règles.

#### Proposition

_Par simple configuration (un booléen Vrai/Faux) il doit être possible d'indiquer si un objet entre dans ce mode de gestion de configuration ou si on étudie ses évolutions de manière indépendante._

### Unicité de version active

Sur le coup je ne vais pas avoir beaucoup d'arguments. C'est plus l'expérience d'avoir utilisé et développé différentes solutions de gestion de configuration qui m'amène à décider que l'on doit figer ce principe de ne pas pouvoir avoir deux version actives en même temps, dans un contexte de gestion de configuration de définition. Cela n’empêche pas un industriel de produire deux versions d'une carte électronique, la capacité à produire une configuration étant décorrélé d'un état de définition.

#### Proposition

_Si une version est validée (Released) sa version précédente est rendu obsolete par remplacement (Superseded). Le même mécanisme est disponible dans le cas présenté du "superseding Fork"_.

## Next

Shocking or not shocking ? Je vous laisse commenter et serai ravi d'échanger sur le sujet. Dans un prochain article, je présenterai les différents scénarios, graphs à l'appui, de révision et de prise de nouvelles références. Soyez prudents pour le déconfinement !
