---
title: "je rêve d'un PLM \"API-First\""
date: 2019-02-11
categories: 
  - "api"
  - "microservices"
  - "plm"
coverImage: "apiservices.jpg"
---

J'étais intervenu il y a quelques années lors d'une conférence Back to basics du [PLMLab](http://plmlab.fr/), pour parler d'une initiative Open Source d'un démonstrateur d'API rest pour PLM. Le but était de démarrer un petit projet Open Source et collaboratif pour développer une API sans se poser la question de performances au début mais plus pour lister les différents besoin en termes d'API pour une architecture PLM.

L'article concernant cette initiative est ici : [PLMapi un projet Open Source d’une plateforme d’API PLM](http://plm-ouvert.fr/2015/10/plmapi-projet-open-source-dun-plateforme-dapi-plm/)

Et la documentation de la plate-forme fonctionne encore (vous ne pouvez juste pas exécuter les appels du web-service, le serveur n'étant plus actif.) : [https://plmapi.readme.io/](https://plmapi.readme.io/)

## Pourquoi l'API est importante?

Parce qu'une solution PLM ne couvrira jamais tous vos besoins et que le PLM doit interagir avec quasiment tous vos autres systèmes d'entreprise. Et c'est valable dans les deux sens. Vos autres applications auront elles aussi besoin d'échanger avec votre solution PLM.

## Quels types d'appels REST pour le PLM

C'est la que j’espérais pouvoir avoir des retours dans la démarche du projet PLMapi. Le but était de lister tous les besoins types dans un contexte PLM.

[  
![](images/appelsRestPlmApi.png)](https://plmapi.readme.io/)

Les appels API doivent être assimilées à des services. De quoi ai-je besoin?

- Trouver un document
- Visualiser une nomenclature
- Mettre à jour des informations d'un fournisseur
- Faire avancer le statut du cycle de vie d'un article
- ...

Pour certains de ces appels on retrouve des fonctions CRUD (Create Read Update Delete) classiques pour d'autres les services sont un peu plus poussés en termes de logique (recupération d'une liste d'éléments impactés par un ECO, voter la promotion d'un document,...)

## OSLC?

En parlant d'API dans le PLM certains me parleront surement d'OSLC. Open Services for Lifecycle Collaboration, est un standard géré par Oasis. Je ne vais pas refaire toute la chronologie d'OSLC ni la description détaillée de ce concept. En gros, c'est une formalisation de web services sous forme d'appel REST basé sur [le web des données (Linked Data)](https://fr.wikipedia.org/wiki/Web_des_donn%C3%A9es). Le tout a été largement poussé par IBM pour donner plus de légitimité à la suite Jazz (avis personnel) alors qu'il y a largement assez d'outils d'intégration standardisées dans le web d'aujourd'hui.

https://www.youtube.com/watch?v=B2vqL8fujgE

Personnellement ma vision d'OSLC est la suivante: pourquoi avoir refait un standard et pourquoi avoir tant réalisé cette démarche en poussant la plateforme Jazz. Cela ne pouvait pas sérieusement permettre l'adhésion d'une communauté technique du PLM.

![](images/standards.png)

## Documentation

Aujourd'hui les solutions de documentation automatisées d'API sont monnaies courantes et même standardisés avec des démarches comme [OpenAPI](https://www.openapis.org/). On ne peut plus faire l'économie d'une bonne documentation pour permettre au intégrateurs et au collaborateurs IT de l'entreprise d'intégrer cette API. [Je prévois à ce sujet un article sur Swagger.](https://swagger.io/)

## Modèle économique

Se pose au final la question du modèle économique. quelques idées:

- à l'utilisateur
    - C'est classique dans le PLM, mais il y a un moment où le PLM ne devrait être qu'une liste de services sans réels liens avec les utilisateurs qui eux seraient gérés par un IAM (Identity & Access Management)
- à la transaction?
    - Ce serait original, cela pourrait faire peur initialement mais c'est aussi ce que l'on voit de plus en plus dans les services cloud, une facturation au nombre d'appels des API. Exemple, pour utiliser l'API Google Map, Si les utilisateurs appellent le services de calcul de direction 100 000 fois, Google vous facturera 426€. ([retrouver les tarifs ici](https://cloud.google.com/maps-platform/pricing/?hl=fr))
- Au dimensionnement du serveur
    - C'est un peu le modèle des bases de données, pas sûr que ce soit simple ni novateur dans le domaine.

## Conclusion

Je pense que moins de 5% des personnes décisionnaires dans l'acquisition d'une solution PLM connaissent la valeur d'une API bien réalisée (Il faudrait évaluer en relisant les RFP qui évaluent la partie API des solutions). C'est dommage car c'est par là que la facilité d'intégration du PLM dans l'environnement de l'entreprise sera facilitée. A nous, consultants et éditeurs consciencieux de faire de la pédagogie pour les 95% de décideurs qui n'ont pas encore vu la lumière :)

Si l'initiative d'API-first vous intéresse, contactez moi, il y a plein de choses utiles et simples potentiellement à mettre en place.
