---
title: "Le verrouillage logiciel, toujours un problème majeur du PLM"
date: 2018-11-05
categories: 
  - "plm"
coverImage: "jail.jpg"
---

Le domaine du PLM est connu pour ses cycles de ventes extrêmement longs et ses déploiements tout aussi longs. Chaque communiqué de choix d'une solution sonne comme un mariage entre deux entités qui ne se connaissent pas forcément bien, n'ayant eu que 18 mois pour se connaître et n'ayant montré que le plus beau de ce qu'ils pouvaient faire pendant cette période.

## Le cœur du problème : les données

Imaginez, vous êtes responsable du PLM, vos utilisateurs se plaignent depuis longtemps du temps de chargement de formulaires, de l'impossibilité de naviguer certains liens pour retrouver de la donnée, vous n'en pouvez plus de la solution logicielle que vous aviez décidé d'implémenter: vous appuyez sur un gros bouton rouge qui vous permet de changer de solution PLM en quelques jours, ou juste de remplacer certaines interfaces métiers par d'autres.

![](images/thatwaseasybutton-1024x682.jpg)

Le problème c'est que ça n'est possible parce que vos données sont dans un système avec un schéma bien spécifique. Et c'est clairement ce point qui fait mal. Comment puis-je transférer toutes mes données d'un système à l'autre? Dois-je le faire d'un coup? Ce projet de migration peut prendre du temps, coûter très cher en ressources, va demander un temps de validation important.

## Solution pragmatique 1 : les standards !

J'en parle depuis longtemps et le [PLMLab](http://plmlab.fr/) communique aussi dans ce sens: les standards, les standards, les standards!! Si vous commencez à utiliser un nouveau logiciel, ou à équiper un nouveau service, pensez "Standards". Il ne seront pas tous bons. Il n'existent pas forcément pour tous vos besoins, mais des têtes bien pensantes ont travaillé sur le sujet pour vous aider dans la quête de l'indépendance des éditeurs et surtout pour faciliter vos échanges avec d'autres entreprises qui auront fait la même démarche que vous.

Le plus connu des standards dans le PLM est [STEP](https://en.wikipedia.org/wiki/ISO_10303). Il se décline en une multitude de domaines et d'activités. Vous pouvez décrire des géométries pour la CAO et vous pouvez supporter toute votre activité de maintenance et support avec PLCS. Donc la prochaine fois que vous étudiez une solution pour votre démarche PLM, si vous n'avez pas étudié les standards, vous ne viendrez pas vous plaindre par la suite !!!

## Solution pragmatique 2 : découper son PLM !

Ne mettez pas vos œufs dans le même panier. Vous serez en maîtrise de votre solution PLM. Même si vous faites intervenir une entreprise avec un rôle d'intégrateur, vous pourrez avec cette entreprise programmer plus facilement le remplacement de telle ou telle partie de votre environnement supportant votre démarche PLM. Cela veut dire aussi que vous aurez une plus grande capacité à négocier ou à faire pression sur l'éditeur. Par contre, en phase d'achat il se peut que vous soyez moins choyés par les éditeurs qui n'ont pas l'habitude d'avoir des clients qui découpent leurs environnements PLM. Cette solution a pour conséquence, cependant de largement complexifier la gestion end-to-end de l'information. A vous de transformer cette conséquence en un atout long-terme en vous appuyant sur des plate formes transversales supportant les standards.

Pour plus d'information sur la possibilité de découper son PLM, je vous invite à suivre mon blog en anglais : [http://plmstack.com/](http://plmstack.com/)
