---
title: "Réflexion sur le Branch & Merge, exemples de OnShape"
date: 2018-10-22
categories: 
  - "cao"
  - "plm"
coverImage: "5488984404_c37e1d60a2_o.png"
---

La gestion de branches est une notion classique en développement logiciel. C'est un process largement outillé et connu depuis que des gestionnaires de sources ont vu le jour et se sont démocratisés avec des solutions comme [CVS](https://fr.wikipedia.org/wiki/Concurrent_versions_system), [SVN](https://fr.wikipedia.org/wiki/Subversion) ou plus récemment [GIT](https://git-scm.com/) (devenu le standard par l'usage). Le principe fonctionnel pour les collaborateurs partageant un tel gestionnaire de sources est assez simple. Chaque utilisateur récupère une copie des sources du logiciel développé. Un développeur réalise des développements, modifiant, supprimant ou ajoutant des fichiers et/ou lignes de codes. L'écart observé est alors soumis au gestionnaire de sources. Le gestionnaire de source permet alors d'enregistrer ces écarts et potentiellement de repartir d'une photo antérieure pour étudier une alternative. Cela permet aussi à deux collaborateurs de travailler en parallèle à partir d'une même configuration (attention ça n'est pas de la co-conception en direct). Ces deux collaborateurs doivent avoir pour bonne pratique de soumettre leur code dans des conteneurs différents avant de tenter de fusionner. Ces deux conteneurs sont des **branches**.

\[caption id="" align="aligncenter" width="730"\]![](images/1*DdYlOjNeO3aVM1Bzrjv4ig.png) Branches\[/caption\]

## Deux usages

Il y a donc deux usages principaux des branches:

- L'étude d'alternatives
    - Un utilisateur repart plusieurs fois d'une même image et enregistre chaque étude de conception
- la co-conception différée
    - Chaque utilisateur part de la même image et les différentes branches correspondent aux développements de chacun.

\[caption id="" align="aligncenter" width="800"\]![](images/merge-tool-1-copy-1.png) fusion de deux versions de code dans gitKraken\[/caption\]

## L'avantage du code informatique

L'avantage de cette gestion pour le code informatique est très largement lié au format de ce qui est développé: du code informatique = des pages de texte. Il est en général assez simple de comparer deux fichiers sources et d'en évaluer les différences. En mécanique il est déjà plus compliqué d'avoir cette description textuelle à moins d'utiliser des standards de description de formes géométriques comme le Part21 par exemple.

OnShape, une CAO full-cloud a mis en place ce type de mécanisme permettant de développer plusieurs évolutions d'un modèle mécanique et s'il n'y a pas de conflits, de fusionner ces évolutions.

https://www.youtube.com/watch?v=rJ20UToqtGM

C'est d'ailleurs la grande illusion de l'informatique, on imagine souvent que Git, conceptuellement règle tous les problèmes de collaboration en développement logiciel. Bien sûr aujourd'hui il devient compliqué de faire sans, mais passant moi-même beaucoup de temps à faire du développement collaboratif ou à jouer le rôle d'intégrateurs sur des repository GIT, je sais à quel point il est important d'établir des règles claires de style de code, de syntaxe,etc. La co-conception même différée sur des parties similaires d'un code réserve souvent des surprises à la fusion. Il est important de s'outiller pour faciliter le test de chaque évolution (qui peut nécessiter beaucoup plus de besoin en calcul pour des modèles mécaniques et électroniques.)

## L'application au PLM

Quid du PLM dans tout ça. J'ai souvent eu cette question du branching sur des évaluations de solutions PLM. Faut-il permettre cette fonction ou est-ce que cela doit être une fonctionnalité gérée par les outils d'authoring?

Sur la gestion du logiciel, aucun PLM ne remplace GIT. En général, pour l'instant le logiciel entre en tant que build ou tag d'un repository. C'est cette photographie, ce point d'ancrage, qui est utilisé dans la gestion de configuration du produit pour lequel ce logiciel est destiné.

Pour la conception mécanique, on m'a souvent demandé la gestion de branches au niveau des ECO/ECN. Permettre la création d'alternatives pour faciliter la prise de décision. La complexité vient de la façon dont est géré le stockage d'un gestionnaire de versions. Dans les solutions PLM il est souvent fait des copies d'objets (avec du contenu qui peut être volumineux) alors que Git va gérer des écarts combinés avec une stratégie de compression qui limite la taille des données distribuées sur chaque poste (si on respecte l'usage de GIT).

Ci-dessous vous trouvez l'enregistrement d'un webinar sur la gestion des versions, des branches et de la fusion de modèles mécaniques avec OnShape. OnShape a la solution pour leur CAO. Y'a t'il un PDM qui pourrait se définir comme le GIT de la conception non-logicielle? A-t'on besoin de cela si de toute façon demain toute la conception logicielle, électronique et mécanique se basera sur du code par l'ingénierie système. La réflexion suit son cours...

 

https://www.youtube.com/watch?v=QHEKB2tO4-8
