---
title: "Les instants « wow » de la formation Aras Innovator – Episode 2"
date: 2018-09-03
categories: 
  - "aras-innovator"
  - "plm"
coverImage: "thatwaseasybutton.jpg"
---

J'avais lancé cette série il y a longtemps avec une première introduction [à la réalisation d'un itemtype dans Aras Innovator](http://plm-ouvert.fr/2016/12/linstant-wow-de-la-formation-aras-innovator-episode-1/). Je poursuis avec une présentation beaucoup plus technique mais qui illustre bien la résilience de la solution Aras Innovator et sa capacité à communiquer avec le reste du monde.

## La syntaxe de requête AML

\[caption id="attachment\_2969" align="alignnone" width="900"\]![AML](images/AML.png) AML (extrait de la formation Aras Innovator – Developing Solutions© )\[/caption\]

L'AML "Adaptive Markup Language" est le format de données échangées entre le serveur PLM Aras et les clients utilisateurs, principalement le navigateur web, mais aussi toutes les applications qui vont s'interfacer avec Aras Innovator. L'AML est du XML avec un ensemble de propriétés et d'attributs et une structure propre au modèle de données Aras.

\[caption id="attachment\_2962" align="alignnone" width="900"\]![](images/CaptureAML-1024x598.png) Structure de l'AML (extrait de la formation Aras Innovator - Developing Solutions © )\[/caption\]

### Exemples

#### Exemple pour récupérer l'ensemble des articles

\[xml\] <AML> <Item action="get" type="part"> </AML> \[/xml\]

#### Exemple pour récupérer tous les documents dont l'"item-number" commence par "Doc"

\[xml\] <AML> <Item action="get" type="document"> <item\_number condition="like">DOC-\*</item\_number> </Item> </AML> \[/xml\]

#### Exemple pour mettre à jour une quantité dans une nomenclature

\[xml\] <AML> <Item action="edit" type="part Bom" where="\[part\_bom\].source\_id='046F9545323D4CA3A6A9B9BD226DD6C2' and \[part\_bom\].related\_id='7A4E218774534F4CAF1629B15B31F73A'"> <quantity>10</quantity> </Item> </AML> \[/xml\]

#### Exemple pour créer un projet

\[xml\] <AML> <Item type="Project" action="add"> <name>TestAdding Project</name> <scheduling\_type>Forward</scheduling\_type> <project\_update\_mode>1</project\_update\_mode> <date\_start\_target>10/7/2009</date\_start\_target> <date\_due\_target>10/8/2009</date\_due\_target> </Item> </AML> \[/xml\]

#### Exemple pour créer un article avec un document existant attaché

\[xml\] <AML> <Item action="add" type="Part"> <name>Xcd Board 47</name> <item\_number>PRT-BRD-47</item\_number> <Relationships> <Item action="add" type="Part Document"> <related\_id> <Item action="get" type="Document"> <item\_number>DOC-000001</item\_number> </Item> </related\_id> </Item> </Relationships> </Item> </AML> \[/xml\]

#### Exemple pour exécuter la promotion d'un item

\[xml\] <AML> <Item type="{Item Type}" action="promoteItem" id="{ID of Item}"> <state>{Name of the new state}</state> <comments>{Additional comments to store in history. Optional.}</comments> </Item> </AML> \[/xml\]

#### Utilisation d'opérateurs logiques

\[xml\] <AML> <Item action="get" type="part"> <or> <and> <cost>350</cost> <classification>Product</classification> </and> <and> <cost>100</cost> <classification>Assembly</classification> </and> </or> </Item> </AML> \[/xml\]

### Respect des permissions

Toutes ces requêtes se réalisent dans un contexte authentifié et donc identifié. Chaque requête va être exécutée par une identité dans Aras Innovator et sera soumise aux vérifications de droits et permissions de l'utilisateurs.

### Les outils

A l'origine Aras fournit dans l'application une page sur laquelle il est possible de saisir de l'AML et de récupérer la réponse du serveur. C'est le NASH.

![](images/CaptureNash-1-1024x798.png)

Autour de 2008 si je me souviens bien, un client Aras était venu en formation de développeur et avait pris l'initiative de développer un client windows qui permette de rédiger ces requêtes avec l'aide de l'auto-completion. A l'époque AML studio a donc été réalisé et est encore utilisé aujourd'hui dans les formations Aras.

![](images/AML-studio11.png)

Voici une vidéo qui présentait l'application AML studio : https://www.youtube.com/watch?v=BMq9hnEDB90

Depuis quelques temps le projet AML studio a été remplacé par un outil plus riche, **[Innovator Admin:](https://github.com/erdomke/InnovatorAdmin)**

![](images/innovatorAdmin-studio.png)

### Un contrôle de toute l'application

L'AML permet de manipuler toute l'application. Dans les exemples précédents je ne montrais que la partie manipulation de données, mais l'exemple suivant vous permet de manipuler le modèle de données.

#### Ajout d'une propriété sur l'itemtype Part

\[xml\] <AML> <Item action="edit" type="ItemType" where="\[itemtype\].name='Part'"> <Relationships> <Item action="add" type="Property"> <name>description\_tech</name> <label>Description Technique</label> <data\_type>text</data\_type> </Item> </Relationships> </Item> </AML> \[/xml\]

C'est ce type d'AML qui permet de gérer tous le packaging, et autres opérations d'upgrade à travers un format d'échange "standardisé".

[La formation Aras](https://www.aras.com/university/training-classes.aspx) permet de voir le détail des attributs disponibles et de parcourir différents exemples pour devenir autonome sur ce type de manipulation d'Aras Innovator.
