---
title: "Continuité numérique et entreprise(s) étendues"
date: 2017-12-03
categories: 
  - "integration-de-donnees"
  - "plm"
tags: 
  - "continuite-numerique"
  - "entreprise-etendue"
  - "micro-services"
  - "standards"
coverImage: "system-2457648_1920.jpg"
---

Continuité numérique ("digital thread" pour les plus anglo-saxons d'entre nous), c'est le credo du PLM depuis quelques années. Ce n'est pas une découverte ou une nouvelle orientation du PLM, c'est plus un axe marketing fortement développé pour supporter la communication des principaux éditeurs. L'analyse des méthodes et des technologies qui supportent cette stratégie est ensuite à analyser et à évaluer par les entreprises utilisatrices.

## Objectifs de la continuité numérique

L'assurance de la continuité numérique dans un système d'information supportant une démarche PLM a potentiellement plusieurs objectifs métiers:

- Gain de temps et réduction des non qualités dans le passage d'information d'une étape de conception à une autre.
- Cela augmente la capacité des entreprises à itérer dans leur conception
- Capacité de justifier les données de conception (pour réaliser un nouveau design/process, ou pour retrouver la cause d'un incident)

D'un point de vue technique, le but est clair, permettre de connecter tous les nœuds d'information gérés par l'entreprise avec une ontologie (un dictionnaire) facilitant l'inter-action de ces nœuds (si je modifie un article je veux que le produit parent soit notifié/impacté) et facilitant la navigation d'un nœud à l'autre.

## Le challenge de l'entreprise étendue

Partons de l'observation métier. La réalisation d'un produit, non seulement sa conception, mais tout son cycle de vie, est de plus en plus distribuée. Que ce soit un découpage par étape du cycle de vie (conception pour entreprise A, fabrication entreprise B) ou au sein de mêmes étapes (co-conception de plate-forme de véhicules par exemple), l'entreprise étendue vient apporter une complexité au concept de continuité numérique en amenant les décideurs à un moment ou un autre à délimiter des périmètres de gouvernance IT. Quid des frontières entre les entreprises? Quid aussi des frontières au sein d'une même entreprise pour laisser différents métiers vivre une certaine indépendance de l'évolution de leurs métiers?

## L'usage des standards

Un élément clé de la continuité numérique, avant que l'on intègre tous nos systèmes, était de définir des standards d'échange. Je travaille actuellement sur les standards [S1000D](http://s1000d.org/Pages/Home.aspx) et [S3000L](http://www.s3000l.org/) ([standards ASD](https://www.asd-stan.org/?lang=fr)) et ils sont un bon moyen d'assurer une certaine continuité numérique en permettant aux différents acteurs d'un produit de partager et inter-connecter des données compréhensibles par chacun.

## Les micro-services

Les micro-services vont-il challenger les plate-formes d'entreprises? C'est un peu la question du moment. Est-ce que les solutions IT vont un peu moins se centrer sur une entreprise (Entreprise A, Entreprise B) et plus se concentrer sur des services (Editer un manuel de maintenance, Concevoir un modèle mécanique, faire une spécification) tout en se connectant entre services ([exemple de Zapier](https://zapier.com/))?  Je pense que cette vision, si elle est la bonne, va mettre un certain temps à s'appliquer aux industriels. Le problème n'étant pas technologique, mais plus une considération de gestion de l'historique des entreprises.

## Conclusion

Le discours est attractif (je sais, je le pratique chez Aras). Proposer une continuité numérique est une opportunité métier évidente. La réalisation technique est plus complexe. Entreprises multinationales avec problématiques [ITAR](https://fr.wikipedia.org/wiki/International_Traffic_in_Arms_Regulations) multi-pays, mélanges de cultures de travail encore très différentes, division de sociétés en plusieurs entités. Voilà quelques exemples que j'ai pu rencontrer cette année. Ils posent la problématique, non seulement technique, mais surtout de gouvernance en interne des entreprises pour prendre des décisions clés sur la capacité à améliorer la continuité numérique tout en garantissant une certaine résilience dans un environnement d'entreprise complexe et évoluant rapidement.
