---
title: "[standards] Semantic Versioning 2.0.0"
date: 2017-04-19
categories: 
  - "plm"
  - "standards"
coverImage: "Unix_history-simple.jpg"
---

La gestion des versions est le sujet typique de "oui c'est standard et c'est du détail" mais personne ne le pratique ni de la même façon (logique de versions) ni avec les mêmes termes (sémantique). J'étais donc ravi de voir sur un dépôt github la référence à un "standard" (entre guillemets car non ISO) pour documenter sa rubrique versioning ([le dépôt est d'ailleurs une librairie sympa pour représenter un graph de branching GIT](https://github.com/nicoespeon/gitgraph.js)).

![versionning](images/versionning.jpg)

La page de SemVer apporte plus de précision sur la signification de chaque indice et rappelle justement le fait que tout le monde comprenne à peu près le versioning est bien mais pas assez. Il est important d'avoir un référentiel commun. J'aime particulièrement ce passage :

> This is not a new or revolutionary idea. In fact, you probably do something close to this already. The problem is that “close” isn’t good enough. Without compliance to some sort of formal specification, version numbers are essentially useless for dependency management. By giving a name and clear definition to the above ideas, it becomes easy to communicate your intentions to the users of your software. Once these intentions are clear, flexible (but not too flexible) dependency specifications can finally be made

Et pour être clair sur la sémantique utilisée pour préciser des notions telles que "SHALL", "MUST" ou "RECOMMANDED" SemVer fait là appel aux standards existants ( https://tools.ietf.org/html/rfc2119 ).

## La logique de versioning SemVer

- Corrections de bugs = incrément de l'indice PATCH
- nouvelles fonctionnalités en maintenant la retro-compatibilité = incrément de l'indice MINOR
- toute incompatibilité avec une version précédente = incrément de l'indice MAJOR

le format est alors :

**MAJOR.MINOR.PATCH**

- Quand un indice est incrémenté, tous les indices à sa droite son remis à 0.
- La toute première version de travail est 0.1.0
- La toute première version publiée est 1.0.0

Cela parait tout simple et trivial pour certains, je pense qu'il est bon de le rappeler et de se demander derrière pourquoi, dans d'autres domaines que le logiciel, on retrouve des éléments de versioning très divers.

Quel est votre système? Quels sont les pires systèmes que vous ayez vus? ou tout du moins les plus exotiques?
