---
title: "[Librairie] PLM et gestion des évolutions de données techniques"
date: 2017-03-30
categories: 
  - "cmii-change-management"
  - "librairie"
  - "plm"
coverImage: "archivesPLM.png"
---

Ce n'est pas un livre, mais une étude qui a occupé quelques-uns de mes allers-retours en métro au travail. Le nom complet de cette publication est **"P.L.M. et gestion des évolutions de données techniques: impacts multiples et interchangeabilité restreinte"**. Les auteurs sont [Gilbert Giacomoni](https://www.linkedin.com/in/gilbert-giacomoni-8a611362/) et [Jean-Clause Sardas](http://www.mines-paristech.fr/Services/Annuaire/jean-claude-sardas).

Cette lecture s'est inscrite dans ma démarche de trouver des réponses autour de la gestion des versions dans une nomenclature. Elle m'a d'ailleurs tapé dans l’œil avec la notion d"interchangeabilité restreinte". Le lancement de l'étude, comme de nombreuses discussions ces dernières années, démarre sur le constat que les solutions actuelles limitent les capacités de gestion dans des contextes d'une diversité grandissante, des exigences plus nombreuses et des évolutions toujours plus fréquentes et rapides. Je propose un court survol du document et mes commentaires.

### Évolutions par rang ou date

Les évolutions par rang ou par date ont pour but de cumuler des évolutions sur un produit sans pour autant en impacter toute la nomenclature. Cette méthode permet de simplifier la gestion des évolutions. Elle est vécue comme une accumulation d'évolutions plutôt que comme l'évolution d'une structure. Cependant, elle ne convient pas à tout type d'industrie en fonction des quantités de production et de la diversité produite.

Le document prend l'exemple de mises à jour de documentation dans un produit pour appuyer cette méthode de gestion.

### Évolutions par mises à jour des arborescences de codifications

La gestion d'évolutions à rang ou à date pose le problème de savoir ce que l'on a dans chaque configuration. La réponse est à priori simple, à telle date ou à tel rang, on prend le cumul des modifications et on retrouve notre configuration. Cela fonctionne en effet si l'application des modifications se fait de manière linéaire et que le critère "à partir de" est strictement appliqué.

L'étude aborde donc la problématique d'identification de chaque article en fonction des modifications apportées à son contenu. On comprend vite que selon l'usage de cet article dans une collection d'articles, il est complexe (mais pas impossible) de devoir tout identifier. Rentre alors en jeu le concept d'interchangeabilité pour limiter la remontée d'indices à certains ensembles. Le désavantage par rapport à l'évolution par rang ou date est la perte de mémoire de composition aux nœuds interchangeables.

### Gestion des configurations multiformes

L'étude présente donc une gestion mélangeant gestion à rang ou à date et remontée d'identification des modifications dans la nomenclature. Cette sélection de mode de gestion dépend d'une étude à chaque niveau d'usage, de l'invariance de l'objet à travers l'évolution réalisée.

### Ambitions de traitement automatisable

La question suite à l'analyse de modes de gestion des évolutions, c'est de savoir comment ne pas transformer cela en une explosion du temps de gestion des évolutions. Et l'auteur, sans préciser ici comment l'implémenter, aborde la complexité de gestion dans le cas de multiples niveaux de nomenclatures et de cas d'emplois des éléments modifiés.

L'auteur indique que la notion d'interchangeabilité restreinte n'existe pas dans la sémantique des PLM. Je suis en désaccord avec cette remarque. Il existe sur diverses solutions (et d'ailleurs sur Aras), dans leurs modèles natifs, la possibilité d'avoir une lecture d'interchangeabilité restreinte. Il est nécessaire pour cela que les liens de nomenclatures puissent être eux-même source d'un lien (vers une équivalence, ou une version précédente de l'article fils).

### Repenser l'interchangeabilité

Dans une dernière partie sur l'interchangeabilité j'ai particulièrement noté la phase suivante :

> Toute interchangeabilité est en fait relative à un état des connaissances sur les éléments, les objets et leur environnement(champ, usage,...)

C'est l'élément clé qu'il faut comprendre afin d'intégrer le fait que l'interchangeabilité totale ne peut exister dans l'absolu. Il y aura toujours des cas d'usage que l'on ne connaît pas encore. Une interchangeabilité totale ne l'est donc que jusqu'au moment où une évolution du contexte vient la restreindre. Le problème c'est qu'à ce moment, qui ira re-vérifier toutes ces interchangeabilités jugées totales?

### Conclusion

Même s'il y a quelques schémas descriptifs je trouve dommage qu'il n'y en ai pas eu davantage. Il est toujours plus simple d'expliciter des concepts de gestion de configuration à travers des modèles. J'ai parfois des limites de capacité d'abstraction, et je pense tout de même qu'un peu plus d'illustrations favoriserait la diffusion des savoirs présents dans ce document.

Cependant j'ai découvert cette étude à un moment important où je retrouve différents clients avec des façons diverses de gérer les versions dans des nomenclatures, de capturer des "baselines", de juger de l'interchangeabilité,etc.

Donc un grand merci à [Gilbert Giacomoni](https://www.linkedin.com/in/gilbert-giacomoni-8a611362/) pour le partage de cette étude que vous pouvez retrouver ci-dessous:

[https://halshs.archives-ouvertes.fr/hal-00690159/document](https://halshs.archives-ouvertes.fr/hal-00690159/document)

\[pdf-embedder url="http://plm-ouvert.fr/wp-content/uploads/2017/03/aim2010.pdf" title="plm et gestion des evolutions de données techniques"\]
