---
title: "Interchangeable Item, Replacement Item, Substitute Item"
date: 2017-02-28
categories: 
  - "plm"
  - "standards"
coverImage: "1024px-Two_man_replace_a_main_landing_gear_tire_of_a_plane.jpg"
---

J'ai volontairement gardé les termes en anglais car j'écris cet article à la relecture du standard MIL-STD-480B que vous pouvez trouver sur le site suivant [http://everyspec.com/MIL-STD/MIL-STD-0300-0499/MIL-STD-480B\_4203/](http://everyspec.com/MIL-STD/MIL-STD-0300-0499/MIL-STD-480B_4203/)

Je me suis intéressé à cette norme dans une démarche actuelle de revue de toutes les sources d'information possibles portant sur la gestion de configuration et plus particulièrement sur la gestion des versions. Au sein du [PLMLab](http://www.plmlab.fr/), nous publions des manuels d'introduction aux notions clés du domaine de la gestion de cycle de vie du produit (PLM). Vous pouvez retrouver sur [cette page](http://www.plmlab.fr/index.php?page=documents) (extraits téléchargeables pour les non-adhérents), nos différentes publications.

## 3 niveaux d'interchangeabilité

Le standard MIL-STD-480B propose donc trois niveaux d'interchangeabilité (précisés dans la MIL-STD-280) pour les Configuration Items (articles de configuration). Attention on ne parle pas d’interopérabilité mais bien d'interchangeabilité.

### Interchangeable Item

> One which (1) possesses functional and physical characteristics equivalent in performance, reliability, and maintenability to another item of similar or identical purposes; and (2) is capable of being exchanged for the other item without alteration of the item or of adjoining items, except for adjustment and calibration

Ici la notion d'interchangeabilité se veut universelle. La définition ne l'indique pas clairement, mais on verra que par opposition, le "substitute item" précise un contexte à la notion de remplacement. Il faut donc ici bien prendre en compte que quelque soit l'environnement (que l'on ne connaît pas forcément) l'item interchangeable pourra être utilisé à la place de la source sans aucune modification. Cela ne précise pas forcément si l'apport de fonctionnalité pose problème (j'imagine que non si le système avec lequel il communique ne consomme pas la nouvelle fonctionnalité). Est-ce qu'un ajustement logiciel est compris dans "adjusment and calibration", j'imagine que oui. On verra dans un autre article les conséquences de la qualification d'un item en tant qu'interchangeable.

### Replacement Item

> An Item which is replaceable with another item, but which may differ physically from the original item in that the installation of the replacement item requires operations such as drilling reaming, cutting, filing, shimming, etc., in addition to the normal application and methods of attachment.

La notion de "Replacement Item" permet une adaptation physique afin d'intégrer l'item de remplacement. On rentre déjà dans une problématique plus fine de gestion du remplacement. Dans le monde de la mécanique pure qu'est-ce que cela implique de modifier le calage d'un objet de remplacement? A quel point vais-je devoir prendre en compte la modification potentielle de l'équilibrage de mon système parent? En électronique, est-ce que la modification d'un connecteur rentre dans le cadre d'un "replacement Item"?

### Substitute Item

> An item which possesses such functional and physical characteristics as to be capable of being exchanged for another only under specified conditions in particular applications, or form a list of approved substitute parts without alteration of the item or of adjoining items.

Le "Substitute Item" pointe la capacité d'échanger un article avec un autre dans un contexte donné. On va potentiellement faire référence à de "l'export control" par exemple qui va limiter l'utilisation de certains composants selon le pays d'usage du produit final. On va pouvoir juger de l'interchangeabilité d'articles en fonctions de conditions environnementales. Ces deux exemples sont externes au produit. Pour l'environnement interne, il faudra sûrement câbler cette analyse d'interchangeabilité avec un moteur de variantes qui contrôlera les exclusions de cas d'interchangeabilité.

### Besoin d'évangéliser un socle standard

En tant que fournisseur de technologies en support au PLM, c'est ce domaine fonctionnel pour lequel je manque de réponses claires. Je croise de nombreux consultants fonctionnels qui me content les bonnes pratiques mais qui admettent s'adapter aux pratiques métiers des clients. Est-ce la faute des industriels? Est-ce la faute des consultants fonctionnels? Aidez-moi à trouver ( ou à concevoir) le recueil ou le standard clair sur la gestion de configuration qui soit assez large pour convenir à chacun et surtout fournir aux éditeurs les bonnes réponses fonctionnelles afin de fournir les bonnes technologies.

Je trouve en général que les descriptions de gestion de configuration sont trop vagues et laissent trop de marge de manœuvre pour les industriels et pas assez de clés pour les PMEs. On va continuer à œuvrer dans ce sens avec le [PLMLab](http://www.plmlab.fr/).
