---
title: "Les piliers du PLM : Données, Services, Interfaces et Résilience"
date: 2016-11-22
categories: 
  - "plm"
  - "techniques_logicielles"
coverImage: "Eiffelturm_1887.jpg"
---

J'étais il y a deux semaines à [la conférence Aras "ACE Europe 2016" à Berlin](http://www.aras.com/ACE/2016/EU/default.aspx) et comme d'habitude les communications de [Peter Schroer, le CEO d'Aras Corp](https://www.linkedin.com/in/peterschroer) forment un bon moment pour réfléchir sur les fondamentaux du PLM. J'avais d'ailleurs écrit sur le concept de PLM résilient qui justifiait de ne pas seulement s'intéresser à la partie fonctionnelle d'une solution PLM mais aussi de valider que sur le long terme, les solutions choisies peuvent vous appuyer compte-tenu des aléas de la vie de l'entreprise. Conférence après conférence, j'essaie toujours de juger les bonnes pratiques, les bons concepts, et de capitaliser une sorte d'invariant du PLM et je pense aujourd'hui pouvoir réduire les piliers de bases d'une solution PLM à 4 domaines clés:

- les Données
- les Services
- les Interfaces
- la résilience du système

## Données PLM

Le sujet des données est le plus simple à comprendre car on est assez sensible au besoin d'un support pour stocker nos données. On a quasiment tous saisi des données dans un fichier Excel, puis, pour plus de structure et de contrôle on est passé dans un SGBD comme Microsoft Access. On était déjà à un point où les données étaient structurées selon un besoin métier qui permettait de fournir des vues différentes selon les besoins de l'entreprise. **Le sujet des données est donc de permettre un stockage de données qui correspond à la problématique d'une entreprise et d'en maîtriser l'intégrité et la cohérence.**

- _Poste : Responsable des données de l'entreprise_
- _Responsabilités:_
    - _maîtriser la définition exhaustive des données de l'entreprise._
    - _maîtriser les demandes d'évolutions par l'apport de nouveaux besoins_
- _Problématique PLM: Suis-je capable de maîtriser mon modèle de données? Puis-je stocker une quantité croissante du volume de données? Puis-je simplement mettre ma donnée à disposition et avec quelle performance selon les types de requêtes réalisées?_

## Services PLM

Le sujet des services correspond au canal, au traitement et à la logique que vous allez fournir à vos utilisateurs (humain, machines-outils, objets connectés, applications,...), consommateurs ou contributeurs de vos données. Le monde du logiciel épaulé par le cloud fournit une quantité impressionnante de services à portée d'API. Ce principe appliqué aux entreprises permet de découpler la logique de traitement de l'information avec les données et les interfaces exposées. Cela est d'ailleurs le cas dans les applications logicielles avec [les modèles de type MVC.](https://fr.wikipedia.org/wiki/Mod%C3%A8le-vue-contr%C3%B4leur)

- _Poste : Responsable des API_ 
- _Responsabilités:_
    - _maîtriser la définition exhaustive des services de l'entreprise._
    - _maîtriser l'interaction avec les données existantes_
    - _maintenir une démarche lean pour fournir et affiner les API et les interfaces d'usage pour les différents utilisateurs de l'entreprise._
- _Problématique PLM: Quels sont les services que je peux mettre à disposition? comment je peux recouper différents types de données pour un même besoin? Quelles sont les interfaces que je peux fournir? Quel est mon dictionnaire de services?_

## Interfaces PLM

Une fois que l'on a les données et les services, il nous faut mettre en place des interfaces pour favoriser l'utilisation de l'outil supportant votre démarche PLM par les utilisateurs.

- _Poste : Responsable des Interfaces_
- _Responsabilités:_
    - _favoriser l'adhésion des utilisateurs aux interfaces proposées_
- _Problématique PLM: Quelle est la spécialisation par métiers des interfaces à mettre en place? Quelle technologie d'interfaces va me permettre de mettre à disposition l'information de la meilleure des manières?_

## Résilience PLM

Le sujet de la résilience n'est pas réellement un pilier mais plus le ciment qui va valoriser les données, les services et les interfaces, en apportant une considération de durabilité pour des systèmes d'information qui ont pour vocation à être utilisés sur le long terme. Cette résilience peut se caractériser par une offre logicielle intégrée qui propose des garanties de pérennité sans connaissance des évolutions à venir de l'environnement de l'entreprise. Elle peut aussi se caractériser par la mise en place de stratégies d'archivages et de capitalisation pour maintenir l'accès aux données et de stratégie d'alternatives de services pour maintenir la fourniture de fonctionnalités aux utilisateurs.

- _Poste : DSI_ 
- _Responsabilité:_
    - _garantir la fourniture de services PLM sur le long terme._
- _Problématique PLM: Que se passe t-il quand je fais évoluer un logiciel supportant ma démarche PLM? pourrais-je consulter des décisions d'un processus de gestion de modification dans 50 ans?_

#### Note

Orienté technologie, cet article a pour but de clarifier l'analyse fondamentale de l'outillage en système d'information afin de répondre aux problématiques de gestion de cycle de vie des entreprises. Pour rappel, un système d'information peut s'appuyer sur de nombreux outils. Ces 4 considérations fondamentales se veulent indépendantes de toute proposition du marché.

Chaque pilier présenté est décrit avec une description de poste. Cela n'a aucune vocation à mettre une personne derrière chaque poste. Selon la taille de l'entreprise, il pourrait y avoir selon les extrêmes:

- une personne pour tout faire
- ou un responsable avec des équipes conséquentes pour chaque pilier
