---
title: "Intégration continue pour PLM, l'exemple de Minerva pour Aras Innovator"
date: 2016-05-12
categories: 
  - "aras-innovator"
  - "integration-continue"
  - "plm"
  - "techniques_logicielles"
coverImage: "Minerva-Total-Care.png"
---

Les processus de delivery sont clés dans la valeur apportée par un intégrateur PLM. Comme tout intégrateur de logiciel, il est important que celui-ci maîtrise le processus d'intégration continue (oui cela parait trivial mais c'est bien cela qu'il faut évaluer, plus que la solution elle même). L'intégration est rarement un domaine dans lequel l'éditeur fournit tous les outils. Les intégrateurs, connaissant les contraintes liées aux projets, les infrastructures des clients, les pratiques agiles de développement demandant de pouvoir itérer simplement. Ils sont plus à même de fournir les outils et les méthodologies d'intégrations. L'éditeur se doit de fournir une technologie qui facilite le travail des intégrateurs.

Ayant passé du temps chez [Minerva](http://minerva-plm.fr/) (j'ai créé Prodeos en 2009 avant d'être racheté par Minerva et de devenir Minerva France), j'ai pu être du côté intégrateur et travailler pour faciliter les intégrations. Au début, les process étaient assez simples et avaient pour but un gain d'efficacité. Lorsque je suis parti de la structure, les process d'intégrations continues sont devenus essentiels et plus performants avec un vrai investissement dans ce sens.

Aujourd'hui, j'ai donc voulu poser quelques questions à [Damien Destrez](https://disqus.com/by/damiendestrez/) de Minerva. Damien est "PLM Solution Architect" chez Minerva depuis 2014, il a une importante expérience dans le PLM avec des grands projets du monde automobile et de l'industrie de la défense notamment sur des intégrations CAO complexes de différents éditeurs.

## L'interview !

> Pourquoi avoir mis en place une démarche d'intégration continue chez Minerva?

L'intégration continue prend tout son sens lorsque le modèle d’implémentation (ex : implémentation itérative) est soumis à une charge croissante de tâches répétitives sans aucune valeur ajoutée. Minerva est reconnue pour sa capacité à optimiser les solutions clientes. Cette reconnaissance est d’abord et avant tout basée sur notre capacité à implémenter des solutions dans des temps limités, grâce à la plateforme ARAS Innovator ainsi qu'à notre savoir-faire basé sur l'amélioration continue. De ce fait, toute la gestion des tâches répétitives est pour nous une charge que bien des outils peuvent mieux gérer que nous.

![Minerva Ci Infra](images/Minerva-Ci-Infra.png)

> Quels sont les exemples de problèmes rencontrés lorsque vous n'avez pas cette démarche en place?

Un des problèmes récurent du manque d’automatisation est le déploiement raté à cause d'une étape manquée ou d'un script qui a mal fonctionné. Cela fait souvent perdre des heures voir des jours quand l'erreur ne peut être trouvée que par des actions avancées.

Un autre exemple, moins spectaculaire mais tout aussi impactant cette fois, est le problème des activités manuelles et le temps nécessaire à un développeur pour faire certaines tâches comme restaurer une instance. Les chefs de projets vont avoir des choix difficiles à faire pour des besoins non métiers qui n’apportent pas de valeur au produit final livré, mais qui sont réellement dimensionnant pour le projet lui-même.

Dans notre démarche d'intégration continue, nous avons annulé ces 2 risques à la source. Nous n'avons plus aucune action humaine pour gérer tout ce qui concerne le déploiement ou le "roll back" d'instance. Nous avons notre "Delivery Kit" qui est un "super Template" qui couvre la quasi-totalité de ce qui peut être déployé. Et, nous avons aussi toute une batterie de tests automatisés dédiés au déploiement pour vérifier que chaque étape s'est bien déroulée. Dans le cas contraire, notre intégration continue se charge du "rollback" dans son état précédent dans la foulée.

En termes de temps, nous parlons de 10 minutes maximum pour un déploiement qui aurait crashé sur un chargement de configuration cliente. La plupart du temps, un déploiement avec backup, déploiement de la solution et load de jeux de données de test prend dans les 3 à 5 min. Donc il ne reste aucune raison pour un chef de projet d'éviter le rollback d’une instance complète. Il est à noter que toute notre intégration continue est basée sur du source control.![Minerva-Ci-Process](images/Minerva-Ci-Process.png)

> Est-ce que cette démarche est un argument de vente de vos services d'implémentation PLM, comment faites-vous pour le vendre à des personnes non-techniques?

Cette démarche est un argument de vente car le client sait tout de suite ce qu'il achète. Il est assuré d'avoir des packages qui fonctionnent car ils sont testés, plusieurs fois et ne sont pas altérés en cours de route manuellement. Il est plus facile de vendre des pratiques d'intégration continue dans le processus de développement que de vendre de l'intégration directement au client. C'est un très bon argument qualité qui justifie notre expertise.![Minerva-Total-Care](images/Minerva-Total-Care.png)

> Est-ce que cette méthodologie est applicable à d'autres solutions PLM? quelles seraient les différences, difficultés? des exemples?

La démarche d'intégration continue n'est pas simplement applicable à ARAS Innovator, elle est valable partout où il y a des tâches répétitives avec une probabilité élevée d'erreur humaine. Maintenant il y a plusieurs degrés d'implémentation, on commence souvent l'intégration continue par la génération de packages à partir d'un source control. On implémente esnuite les stratégies de backup et de déploiement. On finit par des batteries de tests automatisés. Il faut ajouter à cela la gestion multi-instances.

Trouver une manière homogène de gérer un projet où le client a une version qu'il utilise et qu'il faut supporter tout en développant la prochaine version sans oublier de la qualifier. La principale difficulté de la mise en place d'une intégration continue est de véritablement quantifier le besoin. Jusqu'où souhaite t'on pousser le besoin d'intégration continue. Essayer de tout automatiser pour le plaisir est une perte de temps si ce n'est pas compris par les différents acteurs d'un projet.

Les difficultés sont ensuite relatives à chaque Framework, certains ont des outils de type batch disponibles que l'on pourra utiliser simplement et d'autres n'auront aucun utilitaire, aucune API, seulement des clients lourds faisant de petites choses à chaque fois, qu'il faudra essayer de remplacer par des scripts ne nécessitant par l'intervention de l'homme.

Lorsque l'on utilise ARAS Innovator, nous avons la chance de n'avoir que le "full stack Microsoft", SQL Server, IIS et tous ces services, donc les environnements sont homogènes. Mais, dans mes expériences passées, j'ai travaillé avec d'autres solutions PLM qui, elles, étaient développées sur des plateformes windows et déployées sur des serveurs Unix avec différentes bases de données et surtout différents serveurs web ! Et là, l'intégration continue prenait tout son sens mais surtout était un véritable cauchemar à manager.

> Merci Damien et bonne continuation avec Minerva !
