---
title: "Deep Learning et PLM : quelles applications ?"
date: 2016-05-04
categories: 
  - "deep-learning"
  - "integration-de-donnees"
  - "plm"
coverImage: "maxresdefault.jpg"
---

Je déjeunais récemment avec un ami entrepreneur et on discutait des prochaines évolutions dans l'IT qui seront vraiment disruptives. A son avis, la vraie prochaine révolution c'est l'utilisation étendue du deep learning. J'ai d'ailleurs étudié les réseaux de neurones lors de mon année d'Erasmus à Barcelone. Les études étaient souvent sur le concept d'apprentissage guidé et sur des choses simples.

Le futur c'est l'apprentissage autonome sur des choses bien plus complexes. Je vous propose ci-dessous la vidéo (en français) de [Yann Lecun](https://www.linkedin.com/in/yann-lecun-0b999), [directeur du laboratoire d'intelligence artificielle chez Facebook](https://research.facebook.com/ai) (et diplômé en 1983 de l'ESIEE). Mon but est, dans un contexte PLM, de réfléchir à ce que le deep learning peut apporter.

https://www.youtube.com/watch?v=RgUcQceqC\_Y

L'apprentissage est aujourd'hui principalement réalisé sur la compréhension du contenu d'images, de vidéos, de sons et de contenu pour des traductions ou même comme chez Google pour des réponses automatisée d'email.

Il y a une donnée qui coûte extrêmement cher dans les projets PLM et qui rend compliqué le changement de fournisseur de solutions : **L'identification et la migration de données**.

## L'apprentissage de la donnée de l'entreprise

C'est une voie qui pourrait être intéressante. Avoir un espèce de robot d'exploration (comme les robots google) qui bénéficierait de l'apprentissage de toutes les entreprises pour savoir identifier la donnée. Il pourrait tout de suite faire la différence entre une information identifiant un document ou un article, une information de EBOM ou de MBOM. Il détecterait les données dupliquées dans des systèmes complètement hétérogènes. (la donnée d'un même article dans une base Access et une solution PLM).

## Les risques du deep learning

Aujourd'hui les compétitions de deep learning demandent par exemple d'identifier des images qui n'ont jamais été vues par le système testé. En fonction des techniques d'apprentissage utilisées par le système testé, celui ci sera jugé par son taux d'échec pour reconnaître le contenu. (un échec n'est pas une incapacité du système à donner une réponse. Il donne une réponse mauvaise). Les meilleurs tournent autour de 6 à 7%, ce qui est d'après Yann Lecun légèrement mieux qu'un spécialiste du domaine concerné par l'image (ex: reconnaître une race de chien). Donc, le risque porte sur l'erreur qui dans certains domaines aura des conséquences plus importantes que dans d'autres.

Si une voiture automatique ne sait pas reconnaître si il a un chien ou un enfant sur le passage piéton, alors, la conséquence sera de toute façon l'arrêt. Si le robot d'exploration ne sait pas s'il a à faire à un coût estimé ou un coût acheté dans une nomenclature, cela peut avoir des conséquences importantes. Le but va donc être de mitiger le risque.

## Conclusion

La question de la détection de la donnée et de la migration de données est extrêmement importante dans un contexte PLM. Je reviendrai d'ailleurs sur ce point avec différentes approches sur ce blog. C'est en général consommateur d'une grande quantité d'analyse humaines et métier. Alors, Le deep learning pourrait devenir un outil intéressant pour faciliter ce traitement. Si on veut voir à plus court terme l'intérêt du deep learning, cela se fera sûrement sur la présentation d'informations structurés adaptés aux besoins contextuels de chaque utilisateurs (c'était la promesse d'Exalead chez Dassault).

### Le petit coup de pub pour [mon école](http://www.esiee.fr/en)

Je suis obligé de faire un petit coup de publicité pour mon école d'où est sorti Yann Lecun en 1983 (mon année de naissance d'ailleurs).

https://www.youtube.com/watch?v=QxRdWIIyDG8
