---
title: "Design Structure Matrix - Implémentation Cockpit"
date: 2016-03-07
categories: 
  - "cognition-cockpit"
  - "ingesystem"
coverImage: "DSM-1.png"
---

## Contexte

La raison de cet article est que nous avons créé un guide ou boite à outils DSM ([Design Structure Matrix](http://plm-ouvert.fr/2016/01/design-structure-matrix-introduction/)) sous Cockpit. Ce guide a été créé dans le cadre d'une prestation client. Ce client avait émis le besoin de pouvoir réaliser des "clusters" (ou groupements) de travaux intelligents.

Plus particulièrement, comment organiser les lots de travaux au mieux sur la partie architecture fonctionnelle du système. Le système en question comportait une centaine de fonctions. Dans ces conditions, le travail d'optimisation des lots de travaux est encore possible mais le résultat n'est sans doute pas réellement optimal et le travail nécessaire pour y parvenir, pas marginal.

Nous sommes rapidement tombés d'accord pour implémenter le DSM sous Cognition Cockpit. Toutes les données sous Cockpit sont déjà liées et ces liens sont autant de dépendances qu'il faut quantifier pour juger de la valeur du lien. Cockpit semble être un outil très bien positionné pour ces analyses systémiques.

# Illustration

https://www.youtube.com/watch?v=s1E2kmh1cWw

# L'implémentation

Nous avons organisé l'outil pour couvrir 5 phases pour identifier et créer ces groupes optimaux:

## 1\. Sélection des éléments à grouper

Sélectionner le type d'artefacts à grouper de façon optimale

## 2\. Calibration de l'algorithme

Calibrer l'algorithme sur base de différents paramètres (nombre de "clusters", type de liens à considérer, pondération des liens, etc.)

## 3\. Performances de l'algorithme

L'algorithme effectue de multiples itérations et à chaque itération il tente d'améliorer son résultat pour tendre vers un optimum. L'algorithme tente d'éviter les optimums locaux. Il est possible de visualiser les performances obtenues par la configuration actuelle de l'algorithme

![](images/DSM-Results.PNG)

## 4\. Visualisation graphique des résultats

Voici un exemple de visualisation sous forme de matrice comme nous l'avons implémentée sous Cockpit.Chaque ligne correspond dans ce cas à une fonction.Chaque carré grisé correspond à une dépendance existant entre l'élément en ligne et l'élément en colonne.Chaque carré coloré, embarquant une série de carrés grisés, est en fait un groupement déterminé par l'algorithme.En survolant les groupements, on obtient des informations telles que la valeur du groupement.Cette vue est très puissante pour cerner rapidement le résultat de l'algorithme et le comparant avec les groupements effectués.

![](images/DSM-Clustering-1.PNG)

## 5\. Générer les groupes optimaux

Une fois les groupements étudiés et la performance de l'algorithme jugée satisfaisante, le guide DSM Cockpit permet de créer les groupes directement sous Cockpit afin de pouvoir travailler sur la base de ce résultat. Il est très aisé de supprimer les groupes de travail nouvellement créés.

![](images/DSM-Groups-generation.PNG)

## Conclusion

Les résultats de cette implémentation sont très encourageants. Nous avons eu l'opportunité dans le cas de cette étude de pouvoir comparer les résultats des groupements effectués par des humains avec ceux de notre algorithme. Des groupements de travaux avaient en effet été réalisés sur ce même jeu de données à priori. Les résultats sont considérés comme très encourageants car très proches de la logique appliquée par les humains.

De plus, nous croyons pouvoir revendiquer que cette application DSM est une première mondiale en ce sens que la méthodologie est appliquée directement dans l'environnement de travail et d'évolution des données.

Habituellement ce genre d'analyse s'effectue sur un lot de données extrait d'un environnement de travail. Les données sont analysées puis un travail de création des groupements est effectué pour recréer les groupes dans l'environnement. Dans le cas de notre "Proof of Concept", la démarche est totalement intégrée à l'environnement et de fait s'effectue de façon naturelle sur des données toujours à jour. L'analyse est de plus aisément reproductible et l'application des résultats de l'analyse est effectuée, encore une fois de façon tout à fait naturelle sous l'environnement de travail.

## Potentielles futures applications

L'application principale de ce guide s'est faite sur un jeu de données d'architecture fonctionnelle d'un client. Nous avons également entamé une investigation sur un planning projet très complexe afin de déterminer les dépendances entre tâches de travail. Les résultats visent à améliorer la répartition de l'effort de gestion et la distribution des lots de travaux pour s'assurer que les travaux qui dépendent le plus des uns des autres soient rapprochés (N.B. que le terme rapproché n'est pas précisé et peut être compris comme physiquement ou non - la solution n'est pas donnée).

Le guide est prêt à être utilisé dans ce contexte et nous pensons que les bénéfices sont d'autant plus conséquents que le planning est complexe.
