---
title: "Quand et pourquoi parle-t-on de Système Complexe ?"
date: 2016-02-23
categories: 
  - "ingesystem"
  - "plm"
coverImage: "maxresdefault-1.jpg"
---

Un billet écrit par [Rida Messaouidi](https://www.linkedin.com/in/rida-messaoudi-bb95aa68), ingénieur système talentueux, avec qui j'ai eu la chance d'évoluer chez Safran et désormais employé chez Airbus Group. Rida est convaincu par la nécessité d’implémenter l’ingénierie système dans nos organisations industrielles et nous fait le plaisir de contribuer à ce blog. Nous l'en remercions chaleureusement.

# Notre monde est _systèmes_

Notre monde se compose de multiples systèmes. Citons par exemple les systèmes économiques, politiques, énergétiques ou informatiques. Nous sommes nous-mêmes en tant qu'individu des systèmes humains incorporés dans une multitude de sur-systèmes (social, culturel, géographique, etc.). _Quand_ peut-on qualifier ces systèmes de complexe ?

Par ailleurs, Je pense qu’il est important de pouvoir identifier un système comme complexe pour pouvoir le gérer en conséquence, c’est à dire lui appliquer les bonnes méthodologies. C’est le _pourquoi_ du titre de ce billet.

# Intégration et émergence

On ne peut parler de système sans parler d'intégration et d'émergence. Je m'explique.

Un système est composé d'un ensemble d'éléments en interaction. La notion de sous-système apparaît. Chaque sous-système apporte des capacités qui lui sont intrinsèques. **L'intégration** des sous-systèmes entre eux fait **émerger** des capacités nouvelles qui ne se trouvent dans aucun des sous-systèmes. Par exemple, les services rendus par une automobile ne peuvent **émerger** que par **l'intégration** des sous-systèmes de propulsion, de direction, de navigation, de protection… Notons au passage que les sous-systèmes sont aussi des systèmes à leur niveau.

# Discerner le compliqué du complexe

Partons des systèmes simples, comme le stylo. La particularité de ces derniers est que l'on est capable de comprendre leur fonctionnement au premier coup d'œil et d'appréhender toutes les possibilités d'utilisation aussi rapidement. Ces systèmes sont également associés à des procédés de fabrication dont le niveau de difficulté est relativement modéré.

Viennent les systèmes compliqués. Ces systèmes, comme la montre mécanique, se caractérisent par le fait d'être composé d'éléments qui entretiennent des relations nombreuses, diversifiées et difficiles à saisir. Cependant, le niveau de difficulté peut être appréhender au sein d'un champ de disciplines. Une personne experte peut posséder la connaissance du système.

Dans les deux cas précédents, la mise en œuvre de méthodes de développement spécifiques comme l'ingénierie système n'est pas indispensable.

Aujourd'hui, et encore plus demain, les clients - particuliers, industriels, gouvernements - sont et seront de plus en plus exigeants. Les systèmes doivent offrir plus de fonctionnalités, interagir avec d’autres systèmes compliqués, mieux et plus vite, être autonomes, plus sûrs... La conséquence est l'apparition des **systèmes complexes**. Ils se composent d'éléments qui entretiennent des rapports nombreux, divers et difficiles à saisir par l'esprit. De plus, très souvent, ces éléments présentent des états différents durant leur fonctionnement et, à plus grande échelle, durant leur cycle de vie. Une personne ne appréhender seule la complexité de ces systèmes, il faut une équipe à même de couvrir les différents champs qui le composent .

Prenons l'exemple de l'avion de combat. Sa conception et son développement impliquent plusieurs dizaines de compétences dans une organisation internationale. Dans ces conditions, il est indispensable de mettre en œuvre des processus, des méthodes et des outils pour faire collaborer tous les acteurs et parties prenantes.

Il peut être intéressant de noter la corrélation existant entre complexité et risque, une complexité croissante allant bien entendu de pair avec un accroissement des risques. Prenons l’exemple d’une partie de la complexité grandissante de nos systèmes : les équipes. Les architectes, ingénieurs et techniciens sont de plus en plus nombreux, proviennent de cultures et de milieux techniques différents, sont de plus en plus éclatés géographiquement et par conséquent ont de moins en moins de relations quotidiennes. Ce qui impose une gestion drastique des nombreux risques induits de natures diverses.

Un dernier exemple avec le chasseur F35 américain et un extrait du cours d’ingénierie des systèmes complexes de Matthieu Aubron. Cet exemple représente sans doute l’un des systèmes les plus complexes jamais réalisé par l’homme, tous ses excès, ses défis, et ses ratés :

[![f35](images/f35.png)](http://plm-ouvert.fr/wp-content/uploads/2016/02/f35.png)

Vous le comprenez, il devient nécessaire de suivre une démarche structurante associée à une nouvelle logique d'étude et de développement : l'ingénierie des systèmes complexes.

[Rida Messaouidi](https://www.linkedin.com/in/rida-messaoudi-bb95aa68)
