---
title: "Design Structure Matrix - Introduction"
date: 2016-01-20
categories: 
  - "ingesystem"
  - "plm"
coverImage: "designstructurematrix.png"
---

Avec ce nouvel article, nous restons dans la thématique des outils d’ingénierie système.

## Design Structure Matrix - Qu'est-ce?

Le Design Structure Matrix (matrice adjacente ou N2) est un outil simple, visuel et compact pour effectuer (entre autres) l'analyse et la gestion des systèmes complexes. Il permet à son utilisateur de modéliser, visualiser et analyser les dépendances parmi les entités de n'importe quel système (technique ou non) et suggère de puissantes améliorations ou synthèses du système.

## La dépendance au cœur de l'analyse

Lorsque l'on analyse un système complexe, les liens entre les composants du système sont d'une grande valeur. Le nombre, le type et la "force" des liens indiquent la dépendance entre deux éléments.

> Est-ce un lien de "_safety_", et quel niveau de criticité a ce lien? Est-ce un "_flux d'information_" qui transite entre deux fonctions? Est-ce un lien à l'ordre 1, 2 ou 3? etc.

Chaque lien a une valeur, qui doit être quantifiée:

- La somme des liens entre deux éléments crée leur force de dépendance,
- La force de dépendance indique le degré d’interaction,
- Le degré d'interaction donne un indicateur du niveau d'intégration nécessaire pour rendre le tout optimal,

Plus les éléments sont dépendants, plus ils requièrent d’interactions. **Or, une interaction a un coût qui peut également se matérialiser par un risque.**

Le DSM vise à minimiser le coût de ces interactions en organisant un rapprochement (physique ou virtuel) entre les éléments les plus dépendants. Le DSM va tenter de trouver les regroupements optimaux répondant aux critères de l'analyse.

## Illustration:

\[table id=2 /\]

Au travers du Design Structure Matrix, nous allons donc analyser un système et créer des groupes de travaux optimaux. Ces groupes de travaux, basés sur la valeur des dépendances, peuvent être de toute nature à partir du moment où ils sont composés d'éléments inter-connectés. C'est là toute la magie du Design Structure Matrix. Un outil simple pour optimiser tout système. Il faudra certainement pour les novices un exemple pratique pour mieux s'en faire une idée.

## 3 avantages à analyser les systèmes au travers des matrices de dépendances

Voici 3 forces du DSM extraites de [Wikipedia](https://en.wikipedia.org/wiki/Design_structure_matrix):

- La matrice peut représenter un large nombre d’éléments d'un système et leurs relations de façon très élégante et compacte en plus de mettre en lumière les structures de la donnée (comme des rétroactions ou des modules),
- La représentation matricielle va autoriser l'utilisation de toutes les techniques d'analyse matricielle pour améliorer la structure du système,
- Dans le cas de la modélisation d’activités de précédence (comme le planning ou les processus), le DSM va permettre de représenter les liens de retro-actions qui ne peuvent être modélisés par les diagrammes de Gantt/PERT.

## A suivre

Dans un prochain article, nous verrons la mise en application des matrices de dépendance à l'analyse d'une architecture système.

## Pour aller plus loin

Pour plus d'informations, veuillez vous rendre sur [DSMWeb.org](http://www.dsmweb.org/), la référence du web en anglais.
