---
title: "PLMapi un projet Open Source d'une plateforme d'API PLM"
date: 2015-10-07
categories: 
  - "cloud"
  - "plm"
  - "standards"
coverImage: "opensource.jpg"
---

Au mois de mai dernier j'avais écris un article en imaginant [une API standard pour le PLM](http://plm-ouvert.fr/2015/05/une-api-standard-pour-le-plm/ ‎). J'avais pris comme exemple le site [Akido](https://www.akidolabs.com/), qui propose une API pour gérer des informations hospitalières de type Patients, Médecins,... La documentation de l'API de ce site est excellente, car elle permet de tester en direct les différents points REST (webservice) mis à disposition. Je terminais l'article sur la possibilité d'avoir un tel projet appliqué au PLM en indiquant _que l'espoir faisait vivre_ et que j'étais prêt à apporter mon support à l'initiative. Je vais aller un peu plus vite que cela et avec plus d'implication puisque **je lance un projet Open Source au nom de code PLMapi**.

## Un projet modeste

Dans le domaine du PLM, il y a toujours eu une frilosité envers toutes les initiatives de développement de nouvelles solutions compte tenu du fait que les solutions sont perçues comme très complexes avec un temps de développements extrêmement long et un cycle de vente bien trop long pour attirer les investisseurs. **PLMapi** n'a aucune ambition de modifier les modèles établis. Le but est de décrire pour l'instant **un service minimaliste sur un modèle PLM**, qui permette de construire de petites applications dans un premier temps: Créer une nomenclature, prendre des numéros de documents dans Word, récupérer des infos dans Excel,...

Le projet est réalisé en Anglais afin de permettre à un maximum de personnes (ou au moins qui évite une barrière linguistique d'accès au projet) de contribuer ou de développer des applications qui interagissent avec l'API.

## PLMapi les fondements, la licence

L'initiative d'un tel projet, je l'ai déjà expliqué dans de multiples articles sur ma vue du PLM du futur qui se veut découpé en stockage de données, services et interfaces utilisateurs. Le tout doit pouvoir se fondre avec d'autres environnements applicatifs tels que le CRM, l'ERP, APS,... Pour cela, **il faut commencer avec un démonstrateur simple et bien documenté d'une plate forme de services orientés PLM**.

La licence utilisée est la licence MIT (https://opensource.org/licenses/MIT)

> C'est une licence de logiciel libre et open source, non copyleft, permettant donc d'inclure des modifications sous d'autres licences, y compris non libres.
> 
> La licence donne à toute personne recevant le logiciel le droit illimité de l'utiliser, le copier, le modifier, le fusionner, le publier, le distribuer, le vendre et de changer sa licence. La seule obligation est de mettre le nom des auteurs avec la notice de copyright.
> 
> Elle est très proche de la nouvelle licence BSD, seule la dernière clause diffère. Elle est compatible avec la GNU General Public License.

_[Source wikipedia : https://fr.wikipedia.org/wiki/Licence\_MIT](https://fr.wikipedia.org/wiki/Licence_MIT)_

vous pouvez accéder au repository github ici : [https://github.com/YMA-MDL/PLMAPI](https://github.com/YMA-MDL/PLMAPI)

## Un standard, quel standard?

Le MVP (Minimum viable product) de ce projet doit représenter un modèle de données minimaliste pouvant supporter des manipulations de base d'articles, de nomenclatures, de documents,... Le but étant par la suite de déborder sur la gestion de configuration. **Alors quel standard utiliser? STEP? PLCS?** Le modèle de données initial pourra évoluer au début et j'invite les puristes des standards à rejoindre les échanges sur le sujet.

## REST

REST est un des styles d'architecture les plus utilisés aujourd'hui et assez simple à mettre en oeuvre. Il était donc naturel, comme pour le projet [Akido](https://www.akidolabs.com/) de proposer ce type de webservices.

## Quelles technologies?

Pour l'instant tout le service web est développé en PHP en utilisant le framework slim

[![slim](images/slim.jpg)](http://www.slimframework.com/)

La base de données utilisée est une base de données XML qui permet de bénéficier de la capacité du xquery à transformer des structures de données à la volée.

[![basex](images/basex.jpg)](http://basex.org/)

L'utilisation d'une base de données graphique telle que Neo4J ou même une base multi-modèles ArangoDB pourrait éventuellement être étudiée si basex présentait des limitations. Il est même possible de revenir vers une base SQL si les performances le nécessitent.

## La documentation

La documentation est en cours de réalisation, vous pouvez suivre son édition et proposer des suggestions à cette adresse : [https://plmapi.readme.io/](https://plmapi.readme.io/)

## Comment contribuer ?

Il y a des milliers de projets Open Source mais ceux qui attirent une communauté prête à les maintenir sont beaucoup moins nombreux. Je ne m'attends pas à attirer beaucoup de monde, surtout au niveau technique puisqu'une majorité des lecteurs de ce blog sont des fonctionnels ou responsables de projet.

### Développeurs

Le projet est disponible sur [GitHub](https://github.com/YMA-MDL/PLMAPI), n'hésitez pas à me contacter si vous voulez collaborer à vos heures perdues pour développer de nouvelles fonctions.

### Utilisateurs Intéressés

Je pense qu'à ce stade, il ne faut pas attendre beaucoup de choses concrètes. Les premières pierres de la documentation apparaîtront bientôt et cette dernière sera interactive pour vous permettre de tester les services web.

### Intégrateurs

Vous êtes intégrateurs et vos clients demandent parfois de petites fonctions tout en s'assurant de ne pas re-fabriquer une usine à gaz. Développez vos premières applications, vos premiers pluggins office, le but sera dans un premier temps de publier des tutoriels expliquant comment réaliser ces développements.

### Mécènes (pour rappel : Celui qui encourage par ses libéralités les sciences, les lettres et les arts.)

Tout le monde peu être mécène aujourd'hui, il suffit de parler du projet !

**Quel est votre avis sur un tel projet? Vous aimeriez participer? c'est sans espoir? laisser un commentaire !**

Je remercie le site [readme.io](http://readme.io/) pour héberger mettre gratuitement un accès à ses services pour ce projet Open Source.
