---
title: "[Standards] PLCS - AP239 - ISO 10303-239"
date: 2015-06-24
categories: 
  - "plm"
  - "standards"
coverImage: "mroStandardPLCS.jpg"
---

Je poursuis donc ma démarche de découverte des standards. Lors de la journée Back to Basics 12 du PLMLab, j'ai discuté avec quelques personnes de PLCS surtout dans les applications de **M**aintien en **C**ondition **O**pérationnelle (MCO). Il y a quelques semaines, se déroulait à Versailles-Satory le Forum Entreprise Défense. Comme je participe au développement de la solution [Ganister,](http://www.ganister.eu/) que notre premier partenaire est un industriel de la défense et que nous couvrons une partie des besoins en MCO (partie gestion de configuration), j'avais été invité par ce dernier à aller rencontrer les entreprises de la défense pour comprendre leurs besoins en MCO. J'en suis donc venu, dans ma démarche sur les standards, à m'intéresser au standard PLCS ( Product Life Cycle Support).

Avant toute chose, dans ces articles sur les standards, je raconte mes recherches, mes analyses, mes questions qui n'apportent pas forcément de valeur sur le long termes mais plus une porte d'entrée pour aborder chacun de ces standards. Afin de capitaliser les informations qui le nécessitent, sur chaque standard, je produirai un livre blanc et une page dédiée aux standards, que vous retrouverez sur ce site quand j'aurais déjà balayé la plupart des standards courants.

## Recherche d'Information

C'est [Alexandre Tuchot](https://www.linkedin.com/pub/alexandre-touchot/1b/920/156) qui m'a remis sur la piste de l'étude de PLCS avec ce tweet suite à nos échanges lors du PLMLab.

\[embed\]https://twitter.com/atouchot/status/611275425952714753\[/embed\]

Le premier lien ne fonctionnant pas et voulant surtout investiguer l'AP239, je suis le [second lien](https://www.oasis-open.org/committees/plcs/faq.php), qui m'emmène sur le site d'OASIS, ce qui est une bonne chose puisqu’à la différence de la plupart des organismes de normalisation, les informations sur les standards sont disponibles de manière ouverte sur leur site ([revoir mon article sur la recherche de standards](http://plm-ouvert.fr/2015/05/standards-rechercher-standard-cest-mission-impossible/)). La page en question est en fait une explication en Questions/Réponses de la présente de PLCS chez OASIS.

[![Oasis PLCS AP239](images/oasisplcs.png)](http://plm-ouvert.fr/wp-content/uploads/2015/06/oasisplcs.png)

On y apprend d'ailleurs pourquoi PLCS est passé chez OASIS. Nous n'avons pas les raisons de l'arrêt de PLCS inc. qui gérait ce standard, mais ils expliquent qu'OASIS représentait en 2003 l'instance idéale pour poursuivre la gestion de ce standard.

## Les informations sur le standard

### Son contenu

OASIS rappelle le périmètre du standard PLCS : (source [https://www.oasis-open.org/committees/plcs/faq.php#Q4](https://www.oasis-open.org/committees/plcs/faq.php#Q4) )

- Identification and composition of a product design from a support viewpoint (as an extension of the STEP PDM Modules);
- Definition of documents and their applicability to products and support activities (as an extension of the STEP PDM Modules);
- Identification and composition of realized products;
- Configuration management activities, over the complete life cycle;
- Properties, states and behavior of products
- Activities required to sustain product function;
- Resources needed to perform such activities;
- Planning and scheduling of such activities;
- Capture of feedback on the performance of such activities, including the resources used;
- Capture of feedback on the usage and condition of a realized product;
- Definition of the support environment in terms of support equipment, people, organizations, skills, experience and facilities
- Definition of classes of product, activities, states, people, organizations and resources.

Ce qui est intéressant dans cette démarche PLCS est déjà qu'elle est intégrée à STEP puisqu'elle fait partie de l'ISO 10303 - STEP. Et donc qu'elle va étendre certains concepts déjà définis dans d'autres modules de STEP. On le voit pour l'identification des produits qui va être une extension du module PDM de STEP.

### L'identification de l'Article

Ce qui m'intéresse avant tout dans l'étude de ces standards c'est la place de l'article et son modèle de données de proximité appliqué à chaque domaine. Dans le cas de PLCS il y a une reprise de la partie PDM de STEP avec des extensions liées aux activités de MCO. Le lien où j'ai pu trouver un maximum d'information sur le standard est le suivant: [http://docs.oasis-open.org/plcs/plcslib/v1.0/cs01/plcslib-v1.0-cs01.html](http://docs.oasis-open.org/plcs/plcslib/v1.0/cs01/plcslib-v1.0-cs01.html)

On y trouve dans l'index les catégories suivantes :

- Model Usage Guide : Permet de comprendre les équivalent entre le modèle de données PLCS et la traduction STEP pour le format standardisé d'échanges.
- Templates: Liste tous les objets du standard PLCS
- Reference Data

#### Le modèle de données autour de l'article

[![Part PLCS AP239  MRO MCO](images/PartInPLCS.png)](http://plm-ouvert.fr/wp-content/uploads/2015/06/PartInPLCS.png)

Je ne vais pas faire une analyse complète, dans cet article, de ce modèle qui assurément est la partie PDM de STEP. Tout ce que l'on voit c'est qu'on a un fort usage des héritages. Comme on le voit, le Part est un type de Product.

#### Le Modèle conceptuel PLCS

OASIS met aussi à disposition le modèle conceptuel qui permet de rattacher (tout en conservant du sens dans les relations présentées et non simplement des connections) les différentes briques clés de l'activité de MCO autour de la partie STEP PDM (ici en Mauve et Rose pour Product Designs et Product Breakdown)

[![PLCS Concept Model](images/Class_Diagram__PLCSConceptModel__Top-level_concepts1.png)](http://plm-ouvert.fr/wp-content/uploads/2015/06/Class_Diagram__PLCSConceptModel__Top-level_concepts1.png)

 

### Les activités couvertes

Les activités cibles de ce standard sont les suivantes : (source : [https://www.oasis-open.org/committees/plcs/faq.php#Q5](https://www.oasis-open.org/committees/plcs/faq.php#Q5))

- **Activity Management** - Request, define, justify, approve, schedule and capture feedback on activities (work) and related resources
- **Product Definition** - Define product requirements and their configuration, including relationships between parts and assemblies in multiple product structures (as-designed, as-built, as-maintained)
- **Operational Feedback** - Describe and capture feedback on product properties, operating states, behavior and usage
- **Support Solution and Environment** - Define and maintain the necessary support solution for a product in a specified environment including the opportunity to provide support (scheduled downtime), tasks, facilities, special tools and equipment, and personnel knowledge and skills required. PLCS will also relate organizations, personnel and facilities with the product needing support.

Et comme pour le modèle de données qui représente un bloc fixe technique de sauvegarde de la donnée, OASIS met aussi à disposition la description du standard pour les activités de MCO, le modèle d'activités ([http://docs.oasis-open.org/plcs/plcslib/v1.0/cs01/sys/activity\_model\_index\_base.html](http://docs.oasis-open.org/plcs/plcslib/v1.0/cs01/sys/activity_model_index_base.html)).

[![PLCS activity model](images/diagram44.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/06/diagram44.jpg)

 

## Conclusion

Dans la continuité de ma démarche d'exploration des standards, je trouve enfin un élément de standard qui me permet de faire une analyse fine, bien que sur un article de blog, je ne peux que vous faire une brève introduction et vous donner les liens directs aux bonnes informations pour aller plus en profondeur sur ce standard. La lecture de PLCS me permet surtout de me replonger dans les architecture logicielles qui peuvent permettre l'implémentation de telles solutions. Ayant travaillé avec la solution Aras Innovator, il est vrai que l'héritage était une problématique qui n'était pas résolue de manière native. Je ne peux pas parler pour les autres solutions sur lesquelles je n'ai pas parcouru l'architecture technique.

Enfin il est important de valider le déploiement de telles solutions et la quantité d'usage avant de s'investir dans l'adoption de tels standard. Je suis preneur de tout retour d’expérience dans lesquels vous auriez été en contact avec le standard PLCS.
