---
title: "La flexi-traçabilité des cycles de vie et workflows dans les solutions logicielles PLM"
date: 2015-06-08
categories: 
  - "plm"
coverImage: "workflowsLifecycles.png"
---

Quand je caractérise techniquement les solutions PLM, je pars souvent d'un système de gestion de données sur lequel on rajoute des fonctions de versioning, des gestions de relations, etc... puis pour la partie collaborative et la gestion des statuts des objets, les solutions PLM comportent des cycles de vie et des workflows.

Si je me positionne du côté de l'idéaliste technique, pour définir une telle solution je vais étudier tout ce dont j'ai besoin. Je vais dans un premier temps séparer cycle de vie et workflow, je vais permettre au workflow de pousser le cycle de vie, je vais permettre des chemins parallèles dans le workflow, assigner des tâches à des groupes de personnes avec des pondérations de vote, etc... on peut aller loin avec cela en permettant aussi des délégations de signatures, des rappels. Mais quand on vient d'un circuit de signature papier, tout cette architecture n'est-elle pas du luxe?

Alors bien sûr la question de savoir si c'est du luxe va dépendre du coût du système que l'on va sélectionner, mais est-ce que dans de nombreux cas de gestion de cycles de vie, l'offre ne propose pas une trop grande marche? Est-ce que cette marche est visible par les acquéreurs de systèmes équipés de moteurs de worklfows et cycles de vie?

## Quel est le besoin vital?

Cycles de vie et Workflows ont donc deux fonctionnalités bien distinctes:

- Cycle de vie = ensemble de statuts liés par des transitions. Il permet de connaitre l'état d'un objet. On lui demande une traçabilité complète pour savoir ce qui l'a amené à cet état.
- Workflow = ensemble d'activités liées par des décisions de routage qui peuvent être multiples et exécutés en parallèle. Cela permet de distribuer les activités qui vont amener à l'évolution du workflow. Là aussi, cela doit intégrer une traçabilité fine des actions réalisées et de leurs acteurs/responsables.

Donc d'un côté on a un cycle de vie à gérer et de l'autre des activités à assigner. Et pour des soucis de cohérence et d'automatisation, on a relié les deux en s'assurant que l'avancement des activités du workflows puissent se refléter dans l'évolution du statut de l'objet visé.

Il peut y avoir un ensemble de besoins limités et vitaux qui peuvent être intermédiaires par rapport à un système tel que je viens de le décrire. Ces besoin sont:

- s'assurer de l'évolution du statut d'un objet.
- distribuer des actions
- désigner des responsables
- assurer une traçabilité de chaque évolution

## Revaloriser les responsabilités et donner les outils de suivi

Il y a un conseil que j'ai donné à mes clients pour chaque projet dans lequel j'intervenais ces dernières années : "faites confiance à vos utilisateurs". Ne poussons pas à l'excès cette confiance au point de mettre à disposition une base de données avec tous les droits à tout le monde, mon message était surtout insistant envers les chefs de projet qui voulaient tout verrouiller, tout automatiser. Cela coûte cher, c'est plus long à implémenter et ça diminue en général la flexibilité. Vos utilisateurs n'ont pas pour but de détruire votre système n'hésitez pas à laisser une certaine flexibilité, il y a de grandes chances que vous l'appréciez le jour où tout ne se passe pas comme vous l'aviez prévu dans vos spécifications.

## [Ganister](http://www.ganister.eu) l'exemple d'une solution allégée en Workflows

Ganister est une solution qui arrive sur le marché des solutions PLM sur le cloud. Et elle a cette particularité d'avoir un système de cycle de vie assez simplifié avec une représentation graphique assez classique mais interactive puisque la sélection d'un statut de destination se fait directement par sélection de ce statut cible.

[![ganister](images/ganister.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/06/ganister.jpg)

Le concept est assez simple et la configuration se fait à travers un simple fichier de configuration en désignant des statuts et des transitions.

[![ganister_ECOlfecycle](images/ganister_ECOlfecycle.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/06/ganister_ECOlfecycle.jpg)

Ganister simplifie les choses en ne gérant que le cycle de vie et en attribuant à chaque statut un responsable. Charge au responsable de distribuer les actions au travers des objets d'actions qui lui sont disponibles dans l'interface. C'est donc une vision simplifiée de la gestion des cycles de vie qui remet une forte responsabilité à l'acteur du cycle de vie désigné par le statut actuel de l'objet, mais c'est en même temps une marche moins importante à franchir lors de l'implémentation d'une solution PLM qui conserve tout de même la traçabilité de chaque évolution.
