---
title: "arrivée de OnShape sur le marché de la CAO... réflexion dans un cadre PLM"
date: 2015-03-16
categories: 
  - "cao"
  - "plm"
coverImage: "onshapeBlog.png"
---

Le but de ce blog est de parler et d'échanger sur le PLM en général, c'est à dire des différentes composantes de la vie du produit avec une forte orientation IT afin d'aborder les outils qui permettent de supporter les processus et les données qui composent le PLM. Je suis plus électronicien que mécanicien de formation ([ingénieur ESIEE](http://www.esiee.fr/)) et il n'est pas toujours simple de parler de PLM sans connaissance sur la conception mécanique puisque la plupart des acteurs viennent de ce monde. J'ai donc cultivé un intérêt pour la CAO pour répondre aux problèmatiques de mes interlociteurs concernant la place des outils de conception dans le PLM. Ayant déjà "joué" avec les principales CAO modernes ([Solidworks](http://www.solidworks.com/), [Catia](http://www.3ds.com/products-services/catia/), [Nx](http://www.plm.automation.siemens.com/en_us/products/nx/), [ProE](https://www.google.fr/webhp?sourceid=chrome-instant&ion=1&espv=2&ie=UTF-8#q=pro%20engineer),[Inventor](http://www.autodesk.com/products/inventor/overview), [Spaceclaim](http://www.spaceclaim.com/fr/default.aspx) et même [Sketchup](http://www.sketchup.com/products/sketchup-pro) et [Freecad](http://www.freecadweb.org/)), j'essaye d'évaluer en permanence l'effort d'intégration de ces outils dans des environnements de type PLM. Je donne une forte importance à cette capacité d'intégration notamment à travers l'utilisation de standards. En plus de l'adoption des standards, l'utilisation du cloud qui croit au niveau de solutions PLM change aussi la donne. C'est au tour de la CAO de se déployer dans le cloud et de bousculer son marché très lucratif pour les éditeurs.

## Une CAO sur le cloud au tarif très agressif

Cela fait quelques mois que je suivais les communications de la startup [Onshape](http://www.onshape.com/). Après 3 ans de développement, une dernière levée de fond de 64 millions de dollars, [Jon Hirschtik](https://www.linkedin.com/in/jonhirschtick), fondateur et président de [OnShape](http://www.onshape.com/) (ancien fondateur de Solidworks) a lancé ces derniers jours l'accès public à la version Beta de cette nouvelle solution CAO. Deux jours après le lancement, j'ai pu recevoir une invitation pour utiliser cette solution sur mon pc portable qui est loin d'être une formule 1 graphique.

Je dois admettre que le premier test sur chrome m'a posé quelques problèmes de rendu (le support réactif d'[Onshape](http://www.onshape.com/) pense que c'est la carte graphique qui est la cause). Cependant, en utilisant Firefox, je n'ai aucun problème. La navigation, l'ouverture de modèles, la manipulation, la conception, la plupart des actions sont rapides et la navigation est agréable (alors que les serveurs Amazon utilisés sont à Portland,Oregon.

La première interface de navigation dans les différents modèles disponibles ressemble beaucoup à une interface de type Google Doc. Un design simple, sans excès de boutons.

[![OnShape Document list](images/onshape1.png)](http://plm-ouvert.fr/wp-content/uploads/2015/03/onshape1.png)

 

De nombreux exemples de design sont mis à disposition par [Onshape](http://www.onshape.com/) mais aussi partagés par les beta-users. En ouvrant les premiers modèles là aussi il y a peu de boutons (même lorsque l'on est en édition) et une des choses qui frappe rapidement, c'est qu'il n'y a pas de bouton pour enregistrer la conception en cours. Encore une fois on est dans l'esprit Google Docs. Si vous voulez faire des variantes de design ou des versions, c'est tout à fait possible, mais en cours de design le modèle est enregistré en continu.

[![OnShape Motorbike KTM](images/onshape2.png)](http://plm-ouvert.fr/wp-content/uploads/2015/03/onshape2.png)

 

J'ai même pu tester le "snap mode" qui permet de manipuler dynamiquement le modèle selon les contraintes définies.

[![onshape snap mode](images/onshapeSnapMode.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/03/onshapeSnapMode.jpg)

 

Je ne vais pas m'étendre sur les fonctionnalités. Il faut savoir que cet outil s'appuie sur le modeleur de [siemens Parasolid](http://en.wikipedia.org/wiki/Parasolid) (ils n'ont pas réinventé la roue). Et la grande évolution en plus d'utiliser le cloud, c'est le prix de cette solution. La version gratuite vous permet de gérer un maximum de 5 documents et pour avoir un usage illimité il vous en coûtera 100$ par mois (c[e qui par les temps qui courent représente environ 100€](https://www.google.fr/webhp?sourceid=chrome-instant&ion=1&espv=2&ie=UTF-8#q=+dollar+euro)).

Je n'ai pas encore sondé [OnShape](http://www.onshape.com/) pour savoir s'il y avait une distribution de la solution sur des clouds hors des Etats-unis pour non seulement une question de performance mais aussi légale. Ma problématique derrière c'est de savoir ce que va devenir l'intégration avec le reste du cycle de vie du produit.

## Comment intégrer cela dans le cadre du PLM

Alors bien sûr, les concepteurs d'[Onshape](http://www.onshape.com/) n'ont pas limité leurs idées à la solution CAO. Ils le disent lors d'entretiens, ils ont une vision assez large de ce qu'ils peuvent fournir en termes d'outils à la conception de produit, reposant sur le cloud. La problématique est donc de savoir s'ils vont avoir la volonté de s'interfacer facilement avec d'autres systèmes, mettre à disposition des API,etc. Ou alors, vont-il essayer d'étendre leur portefeuille applicatif petit à petit sans laisser de porte ouverte.

Aujourd'hui, dans les explications d'[Onshape](http://www.onshape.com/) sur leur raison d'être, ils expliquent que la demande des clients à changé depuis 20 ans. A l'époque il y avait une forte demande sur les capacités de modélisation alors qu'aujourd'hui le besoin est plus autour de la gestion collaborative des données de conception. Après avoir visionné leur présentation sur la gestion de données, je réalise que cela offre une vraie aisance de gestion des données CAO dans un environnement assez simple pour le moment, cependant je ne suis pas convaincu du fait que leur modèle actuel réponde à la complexité de certaines industries.

[![onshape data management](images/datamanagementOnshape.jpg)](http://plm-ouvert.fr/wp-content/uploads/2015/03/datamanagementOnshape.jpg)

 

Avec cette gestion de données limitée (fonctionnalité PDM) comment intègre-t'on ce système à une solution PLM étendue qui a pour but de couvrir un cycle de vie beaucoup plus large que le processus de conception? Un cas d'emploi typique, ce serait la gestion du changement à travers un ECO. Est-ce qu'il sera possible avec OnShape ou un autre outil de CAO sur le cloud de bloquer l'édition de modèles tant que l'ECO n'a pas créé une nouvelle version ? J'imagine que ces éditeurs pourraient mettre à disposition des webservices qui permettraient à une solution PLM d'être maître de l'état des objets. On en revient à l'article que j'avais écris fin 2012 sur [l'opportunité des API dans le monde du PLM](http://plm-ouvert.fr/2012/11/lopportunite-des-api-reliees-par-un-etl-apport-du-cloud/). Et qu'en sera-t'il des autres CAO, comme l’électronique? L'intégration avec le logiciel? Ce sont des questions auxquelles il va falloir trouver des réponses pour les entreprises qui vont commencer à approcher ces solutions.

\[subscribe2\]
