---
title: "La ptite macro Excel du Dimanche pour reconstruire une nomenclature"
date: 2013-10-20
categories: 
  - "excel"
  - "plm"
coverImage: "ribonPostVBA.jpg"
---

Je profite de ce dimanche pour partager une petite macro Excel que j'utilise depuis quelques temps compte tenu de l'usage d'un format de nomenclature assez constant chez nos clients. Cette macro me permet de recréer des liens de nomenclature à partir d'un fichier Excel dans lequel on retrouve une liste d'articles avec leur niveau dans la nomenclature. C'est assez simple à lire pour l'être humain. On comprend rapidement que quand une ligne a le niveau 3 et que la suivante a le niveau 4, il y a un lien de nomenclature entre les deux. Cependant au niveau d'excel, il n'y a aucune relation. Seul notre regard et notre connaissance du concept de nomenclature nous permet d'en déduire une. Voila un aperçu de ce que je peux recevoir comme nomenclature.

![nomenclature](images/BOM1.png)

Au passage vers la solution PLM il nous faut donc recréer ce lien. Il faut que l'on puisse indiquer pour chaque ligne quel est l'élément parent. Je rajoute donc une colonne après le niveau pour renseigner le part Number de l'élément parent. J'applique ensuite la macro suivante à adapter à votre fichier (Constantes initiales à modifier. Attention à commencer par la ligne en dessous de votre article de tête, 3 dans l'exemple).

\[code lang="vb"\] Sub rebuild()

' initialize constant for your excel file ' Dim StartingLine As Integer StartingLine = 3 Dim Column\_Level As Integer Column\_Level = 1 Dim Column\_ParentRef As Integer Column\_ParentRef = 2 Dim Column\_PartRef As Integer Column\_PartRef = 3

' other technical variables ' Dim j As Integer Dim StoreParents(40) As String

'initialize first parent Part Number ' initParent = Cells(StartingLine, 5)

' Start rebuilding BOM ' j = StartingLine While Cells(j, Column\_Level) &lt;&gt; ""

If (CInt(Cells(j, Column\_Level)) &gt; CInt(Cells(j - 1, Column\_Level))) Then

' level has increased so parentref is previous line part ref ' StoreParents(Cells(j - 1, Column\_Level)) = Cells(j - 1, Column\_PartRef) Cells(j, Column\_ParentRef) = Cells(j - 1, Column\_PartRef)

ElseIf (CInt(Cells(j, Column\_Level)) &lt; CInt(Cells(j - 1, Column\_Level))) Then

' level has decreased so parentref is the stored partRef of new level - 1 ' Cells(j, Column\_ParentRef) = StoreParents(Cells(j, Column\_Level) - 1)

Else

' no level change, we keep the same ParentRef ' Cells(j, Column\_ParentRef) = Cells(j - 1, Column\_ParentRef)

End If

' move to next line ' j = j + 1

Wend End Sub\[/code\]

Vous devriez donc obtenir un fichier avec les références parents indiquées. J'ai fait exprès de lister un article de niveau 3 puis de niveau 1 pour montrer que l'on peut remonter de plusieurs niveaux à la fois sans problème.

![Nomenclature Remontée](images/BOM_Built.png)

 

Voilà mon petit cadeau du dimanche ! C'est pas compliqué mais ça peut servir de temps en temps.
