---
title: "Tutoriel: Restaurer une base de données pour la solution PLM Aras Innovator"
date: 2013-01-28
categories: 
  - "aras-innovator"
  - "plm"
coverImage: "arastut.jpg"
---

Aras Innovator est une solution PLM téléchargeable gratuitement. Le fait de pouvoir l'évaluer pendant une période indéfinie avec un nombre d'utilisateurs non limité, permet de mieux appréhender les phases de projets d'implémentation que vous pourriez traverser lors de votre déploiement PLM. Lorsque vous installez la solution, il n'y a aucune donnée dans la solution, il peut donc être intéressant d'avoir une base avec des informations déjà existantes afin de tester les différentes fonctionnalités telles que présentées dans la plupart des vidéos. Je vous propose donc aujourd'hui un tutoriel sur la restauration d'une base de données existante.

## De quoi se constitue un backup

Un backup se compose potentiellement de 3 éléments:

- **La base de données** : celle-ci contient vos informations de travail telles que vos articles, vos produits, vos projets, etc. Mais elle contient aussi toute la configuration de votre solution PLM, c'est à dire tout votre modèle de données avec les ItemTypes implémentés et leurs relations.
- **Le coffre-fort (Vault)** : Celui-ci contient tous vos fichiers
- **Un delta de votre appli web** : Cela correspond à des modifications qui auraient pu être apportées à certains fichiers de l'application web Aras Innovator. Cela peut aller du simple logo d'en-tête d'Aras, à l'ajout de bibliothèques comme jQuery qui peuvent être utilisées par certaines de vos méthodes. Cela peut aussi être des pages complètement customisées qui auraient été développée dans l'instance que vous désirez restaurer.

## Trouver une base de démo

Rien de plus facile puisque Aras met à disposition cette base pour vous dans la page projet de son site.

- A partir de la page [www.aras.com](www.aras.com) cliquez sur l'[onglet community](http://www.aras.com/aras-community/)

![Aras Innovator community tab](images/restore1.png)

- Cherchez le projet Browse Projects [et cliquez dessus](http://www.aras.com/projects/project-view.aspx?id=59D9F0D66ECC477DB67660F24198695D)

![PLM Demo system](images/restore2.png)

- A partir de [la page du projet](http://www.aras.com/projects/project-view.aspx?id=59D9F0D66ECC477DB67660F24198695D), cliquez sur l'onglet download pour accéder à la dernière version de l'archive à télécharger

![Aras project PLM download system](images/restore3.png)

## Process de restauration

- Il vous faut d'abord décompresser l'archive
- Celle ci se compose, pour cet environnement démo, juste d'une base de données à restaurer (1) et d'un dossier pour le coffre fort (2)

![archive backup Aras demo system](images/restore5.png)

-  Nous allons commencer par restaurer la base de données. Pour ce faire, démarrez l'utilitaire SQL Server Management Studio
- Connectez vous à votre Server

![connect to SQL server microsoft](images/restore6.png)

- Créez une nouvelle base de données![create a new database](images/restore7.png)
- Renseignez le nom de votre base et validez

![create microsoft SQL server database](images/restore8.png)

- Restaurez votre backup, en faisant un clic droit sur votre base de données, puis task, Restore, Database...

![restore9](images/restore9.png)

-  Choisissez  "From Device" et cliquez sur les "..." pour chercher votre fichier de backup

![restore10](images/restore10.png)

-  Cliquez sur "add"

![restore11](images/restore11.png)

- Retrouvez alors le backup ".bak" que vous veniez de décompresser de votre téléchargement.

[![select database backup](images/restore31.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore31.png)

-  cliquez sur Ok

[![validate database backup](images/restore32.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore32.png)

-  Validez la base de données à restaurer en cochant la case (en 1) puis allez sur le panneau Options.

[![valid backup](images/restore33.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore33.png)

-  Cochez l'option "overwrite existing database" cela n'est pas forcément nécessaire comme on vient de créer la base mais, ça permet de prendre une bonne habitude. Puis validez.

[![restore34](images/restore34.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore34.png)

-  Validez le message qui vous indique que la base a bien été restaurée.

[![restore35](images/restore35.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore35.png)

-  Créez une nouvelle requête pour votre base afin de fournir les bonnes autorisations à Aras Innovator pour communiquer avec cette base de données.

[![restore36](images/restore36.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore36.png)

-  tapez le code suivant (cliquez sur l'image pour obtenir le code)

 

[![scripts for database access](images/restore37.png)](https://gist.github.com/4658388)

-  Executez les commandes une par une

[![restore38](images/restore38.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore38.png)

-  Si vous avez installé Aras Innovator normalement, l'execution de la seconde ligne doit vous présenter le message d'erreur suivant, ça n'est pas grave, poursuivez avec la 3ème ligne.

[![restore39](images/restore39.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore39.png) [![restore40](images/restore40.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore40.png)

-  Quittez SQL server et récupérez le dossier de l'archive qui représente votre vault.
- Copiez le dans votre répertoire de vault (par défaut: c:/aras/vault/) et renommez le avec le nom de votre base de données.

[![restore vault backup](images/restore41.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore41.png)

- Allez ensuite rajouter une entrée pour la sélection de la base lors du login.

[![restore42](images/restore42.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore42.png)

- Editez InnovatorServerConfig dans votre repertoire d'installation d'Aras  (par défaut: c:/program files/Aras/Innovator/)

[![restore43](images/restore43.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore43.png)

-  Rajoutez la ligne suivante

[![restore44](images/restore44.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore44.png)

-  Relancez votre serveur web IIS en lançant un iisreset dans une invite de commande

[![restore45](images/restore45.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore45.png)

-  Vous n'avez plus qu'à retourner sur Aras Innovator et votre nouvelle base sera dans votre liste déroulante.

[![restore46](images/restore46.png)](http://plm-ouvert.fr/wp-content/uploads/2013/01/restore46.png)

 

C'est un peu long, mais normalement il ne devrait pas y avoir de problème. N'hésitez pas à poser des questions en commentaire si vous rencontrez un problème.

\[subscribe2\]
